/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.validator;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.util.HtmlEncoder;
import org.operamasks.faces.validator.ClientValidator;
import org.operamasks.resources.Resources;

public class LengthValidator
extends javax.faces.validator.LengthValidator
implements ClientValidator {
    private boolean minimumSet;
    private boolean maximumSet;
    private String message;

    public LengthValidator() {
    }

    public LengthValidator(int maximum) {
        super(maximum);
    }

    public LengthValidator(int maximum, int minimum) {
        super(maximum, minimum);
    }

    public void setMinimum(int minimum) {
        this.minimumSet = true;
        super.setMinimum(minimum);
    }

    public void setMaximum(int maximum) {
        this.maximumSet = true;
        super.setMaximum(maximum);
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        try {
            super.validate(context, component, value);
        }
        catch (ValidatorException ex) {
            FacesMessage facesMessage = ex.getFacesMessage();
            if (facesMessage != null && this.message != null) {
                facesMessage.setSummary(this.message);
                facesMessage.setDetail(this.message);
            }
            throw ex;
        }
    }

    public String getValidatorScript(FacesContext context, UIComponent component) {
        return null;
    }

    public String getValidatorInstanceScript(FacesContext context, UIComponent component) {
        String message = (String)component.getAttributes().get("validatorMessage");
        if (message == null) {
            message = this.message;
        }
        StringBuilder buf = new StringBuilder();
        Aliases a = Aliases.getInstance(context);
        if (this.minimumSet && this.maximumSet) {
            if (message == null) {
                message = Resources._T("JSF_VALIDATE_LENGTH_NOT_IN_RANGE", FacesUtils.getLabel(context, component), this.getMinimum(), this.getMaximum());
            }
            buf.append("new ").append(a.alias("LengthValidator")).append("(").append(HtmlEncoder.enquote(message)).append(",").append(this.getMinimum()).append(",").append(this.getMaximum()).append(")");
            return buf.toString();
        }
        if (this.minimumSet) {
            if (message == null) {
                message = Resources._T("JSF_VALIDATE_LENGTH_MINIMUM", FacesUtils.getLabel(context, component), this.getMinimum());
            }
            buf.append("new ").append(a.alias("LengthValidator")).append("(").append(HtmlEncoder.enquote(message)).append(",").append(this.getMinimum()).append(",null)");
            return buf.toString();
        }
        if (this.maximumSet) {
            if (message == null) {
                message = Resources._T("JSF_VALIDATE_LENGTH_MAXIMUM", FacesUtils.getLabel(context, component), this.getMaximum());
            }
            buf.append("new ").append(a.alias("LengthValidator")).append("(").append(HtmlEncoder.enquote(message)).append(",null,").append(this.getMaximum()).append(")");
            return buf.toString();
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.maximumSet ? 1231 : 1237);
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.minimumSet ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LengthValidator other = (LengthValidator)obj;
        if (this.maximumSet != other.maximumSet) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        return this.minimumSet == other.minimumSet;
    }
}

