/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;

public abstract class AbstractGraphics2D
extends Graphics2D {
    public void clearRect(int n, int n2, int n3, int n4) {
        Paint paint = this.getPaint();
        this.setPaint(this.getBackground());
        this.fillRect(n, n2, n3, n4);
        this.setPaint(paint);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.clip(new Rectangle2D.Float(n, n2, n3, n4));
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new Arc2D.Float(n, n2, n3, n4, n5, n6, 0));
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        this.fill(glyphVector.getOutline(f, f2));
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        double d = (double)n3 - (double)n;
        double d2 = (double)n4 - (double)n2;
        double d3 = (double)n7 - (double)n5;
        double d4 = (double)n8 - (double)n6;
        if (d == 0.0 || d2 == 0.0 || d3 == 0.0 || d4 == 0.0) {
            return true;
        }
        double d5 = d / d3;
        double d6 = d2 / d4;
        double d7 = (double)n5 * d5;
        double d8 = (double)n6 * d6;
        AffineTransform affineTransform = AffineTransform.getTranslateInstance((double)n - d7, (double)n2 - d8);
        affineTransform.scale(d5, d6);
        Paint paint = this.getPaint();
        this.setPaint(color);
        Rectangle2D.Double double_ = new Rectangle2D.Double(n, n2, d, d2);
        this.fill(double_);
        this.setPaint(paint);
        this.drawImage(image, affineTransform, imageObserver);
        return true;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        double d = (double)n3 / (double)image.getWidth(imageObserver);
        double d2 = (double)n4 / (double)image.getHeight(imageObserver);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(n, n2);
        affineTransform.scale(d, d2);
        Paint paint = this.getPaint();
        this.setPaint(color);
        Rectangle2D.Float float_ = new Rectangle2D.Float(n, n2, n3, n4);
        this.fill(float_);
        this.setPaint(paint);
        return this.drawImage(image, affineTransform, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, null, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, null, imageObserver);
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        BufferedImage bufferedImage2 = bufferedImageOp.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
        bufferedImage2 = bufferedImageOp.filter(bufferedImage, bufferedImage2);
        this.drawImage((Image)bufferedImage2, n, n2, null);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.draw(new Line2D.Float(n, n2, n3, n4));
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.draw(new Ellipse2D.Float(n, n2, n3, n4));
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        Polygon polygon = new Polygon();
        int n2 = 0;
        while (n2 < n) {
            polygon.addPoint(nArray[n2], nArray2[n2]);
            ++n2;
        }
        this.draw(polygon);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        Line2D.Double double_ = new Line2D.Double(nArray[0], nArray2[0], nArray[0], nArray2[0]);
        int n2 = 1;
        while (n2 < n) {
            ((Line2D)double_).setLine(((Line2D)double_).getX2(), ((Line2D)double_).getY2(), nArray[n2], nArray2[n2]);
            this.draw(double_);
            ++n2;
        }
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.drawRenderedImage(renderableImage.createDefaultRendering(), affineTransform);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, (float)n, (float)n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        StringBuffer stringBuffer = new StringBuffer();
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            stringBuffer.append(c);
            c = attributedCharacterIterator.next();
        }
        this.drawString(stringBuffer.toString(), f, f2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.drawString(attributedCharacterIterator, (float)n, (float)n2);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new Arc2D.Float(n, n2, n3, n4, n5, n6, 0));
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.fill(new Ellipse2D.Float(n, n2, n3, n4));
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        Polygon polygon = new Polygon();
        int n2 = 0;
        while (n2 < n) {
            polygon.addPoint(nArray[n2], nArray2[n2]);
            ++n2;
        }
        this.fill(polygon);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.fill(new Rectangle2D.Float(n, n2, n3, n4));
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new RoundRectangle2D.Float(n, n2, n3, n4, n5, n6));
    }

    public Rectangle getClipBounds() {
        if (this.getClip() == null) {
            return null;
        }
        return this.getClip().getBounds();
    }

    public Color getColor() {
        Paint paint = this.getPaint();
        if (paint instanceof Color) {
            return (Color)paint;
        }
        return null;
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        if (bl) {
            shape = this.getStroke().createStrokedShape(shape);
        }
        shape = this.getTransform().createTransformedShape(shape);
        Area area = new Area(shape);
        if (this.getClip() != null) {
            area.intersect(new Area(this.getClip()));
        }
        return area.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void rotate(double d) {
        this.transform(AffineTransform.getRotateInstance(d));
    }

    public void rotate(double d, double d2, double d3) {
        this.transform(AffineTransform.getRotateInstance(d, d2, d3));
    }

    public void scale(double d, double d2) {
        this.transform(AffineTransform.getScaleInstance(d, d2));
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip(new Rectangle2D.Float(n, n2, n3, n4));
    }

    public void setColor(Color color) {
        this.setPaint(color);
    }

    public void shear(double d, double d2) {
        this.transform(AffineTransform.getShearInstance(d, d2));
    }

    public void transform(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = new AffineTransform(this.getTransform());
        affineTransform2.concatenate(affineTransform);
        this.setTransform(affineTransform2);
    }

    public void translate(double d, double d2) {
        this.transform(AffineTransform.getTranslateInstance(d, d2));
    }

    public void translate(int n, int n2) {
        this.translate((double)n, (double)n2);
    }
}

