/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.g2recorder;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import org.jfree.pixie.g2recorder.G2Operation;
import org.jfree.pixie.g2recorder.G2Recorder;
import org.jfree.ui.Drawable;

public class G2OpStore
implements Drawable {
    private ArrayList store = new ArrayList();

    public void addOperation(G2Recorder g2Recorder, G2Operation g2Operation) {
        this.store.add(new StoreCarrier(g2Recorder, g2Operation));
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Hashtable<G2Recorder, Graphics2D> hashtable = new Hashtable<G2Recorder, Graphics2D>();
        StoreCarrier[] storeCarrierArray = this.store.toArray(new StoreCarrier[this.store.size()]);
        int n = 0;
        while (n < storeCarrierArray.length) {
            StoreCarrier storeCarrier = storeCarrierArray[n];
            G2Recorder g2Recorder = storeCarrier.getSource();
            Graphics2D graphics2D2 = (Graphics2D)hashtable.get(g2Recorder);
            if (graphics2D2 == null) {
                graphics2D2 = (Graphics2D)graphics2D.create();
                hashtable.put(g2Recorder, graphics2D2);
            }
            storeCarrier.getOp().draw(graphics2D2);
            ++n;
        }
    }

    private static class StoreCarrier {
        private G2Recorder source;
        private G2Operation op;

        public StoreCarrier(G2Recorder g2Recorder, G2Operation g2Operation) {
            if (g2Recorder == null) {
                throw new NullPointerException();
            }
            if (g2Operation == null) {
                throw new NullPointerException();
            }
            this.source = g2Recorder;
            this.op = g2Operation;
        }

        public G2Operation getOp() {
            return this.op;
        }

        public G2Recorder getSource() {
            return this.source;
        }
    }
}

