/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class Buffer {
    private byte[] bytes = null;
    private int length;

    protected Buffer() {
    }

    protected Buffer(int n) {
        this.setCapacity(n);
    }

    public int getByte(int n) {
        if (n > this.getLength() - 1) {
            throw new IndexOutOfBoundsException();
        }
        return this.bytes[n] & 0xFF;
    }

    public InputStream getInputStream(int n) {
        return new ByteArrayInputStream(this.bytes, n, this.bytes.length - n);
    }

    public int getInt(int n) {
        if (n > this.getLength() - 4) {
            throw new IndexOutOfBoundsException();
        }
        return this.getShort(n) & 0xFFFF | this.getShort(n + 2) << 16;
    }

    public final int getLength() {
        return this.length;
    }

    public int getShort(int n) {
        if (n > this.getLength() - 2) {
            throw new IndexOutOfBoundsException();
        }
        return this.bytes[n] & 0xFF | this.bytes[n + 1] << 8;
    }

    public String getString(int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            if (this.bytes[n + n3] == 0) break;
            ++n3;
        }
        return new String(this.bytes, n, n3);
    }

    protected void move(int n, int n2, int n3) {
        System.arraycopy(this.bytes, n, this.bytes, n3, n2);
    }

    public void read(InputStream inputStream, int n, int n2) throws IOException {
        if (this.bytes == null || n + n2 > this.bytes.length) {
            this.setCapacity(n + n2);
        }
        while (n2 > 0) {
            int n3 = inputStream.read(this.bytes, n, n2);
            if (n3 <= 0) {
                throw new EOFException();
            }
            n2 -= n3;
            this.setLength(n += n3);
        }
    }

    public void setByte(int n, int n2) {
        if (n > this.getLength() - 1) {
            throw new IndexOutOfBoundsException();
        }
        this.bytes[n] = (byte)(n2 & 0xFF);
    }

    protected void setCapacity(int n) {
        if (n < this.getLength()) {
            throw new IllegalArgumentException();
        }
        if (this.bytes == null || this.bytes.length == 0) {
            this.bytes = new byte[n];
        } else if (n != this.bytes.length) {
            byte[] byArray = this.bytes;
            this.bytes = new byte[n];
            System.arraycopy(byArray, 0, this.bytes, 0, Math.min(byArray.length, n));
        }
    }

    public void setInt(int n, int n2) {
        if (n > this.getLength() - 4) {
            throw new IndexOutOfBoundsException();
        }
        this.setShort(n, n2 & 0xFFFF);
        this.setShort(n + 2, n2 >> 16);
    }

    protected void setLength(int n) {
        if (n > this.bytes.length) {
            throw new IllegalArgumentException();
        }
        this.length = n;
    }

    public void setShort(int n, int n2) {
        if (n > this.getLength() - 2) {
            throw new IndexOutOfBoundsException();
        }
        this.bytes[n] = (byte)(n2 & 0xFF);
        this.bytes[n + 1] = (byte)(n2 >> 8);
    }

    public void setString(int n, String string) {
        if (n + string.length() > this.getLength() - 1) {
            throw new IndexOutOfBoundsException();
        }
        byte[] byArray = string.getBytes();
        int n2 = this.getLength() - n;
        int n3 = 0;
        while (n3 < n2) {
            this.bytes[n + n3] = byArray[n];
            ++n3;
        }
        if (n + n2 < this.getLength()) {
            this.bytes[n + n2] = 0;
        }
    }
}

