/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf;

import java.awt.Color;

public class GDIColor
extends Color {
    private int flags;
    public static final int PC_RESERVED = 1;
    public static final int PC_EXPLICIT = 2;
    public static final int PC_NOCOLLAPSE = 4;

    public GDIColor(int n) {
        this(GDIColor.getR(n), GDIColor.getG(n), GDIColor.getB(n), GDIColor.getFlags(n));
    }

    public GDIColor(int n, int n2, int n3, int n4) {
        super(n, n2, n3);
        this.flags = n4;
    }

    private static final int getB(int n) {
        int n2 = (n & 0xFF0000) >> 16;
        return n2;
    }

    public int getFlags() {
        return this.flags;
    }

    private static final int getFlags(int n) {
        return (n & 0xFF000000) >> 24;
    }

    private static final int getG(int n) {
        int n2 = (n & 0xFF00) >> 8;
        return n2;
    }

    private static final int getR(int n) {
        int n2 = n & 0xFF;
        if (n2 < 0) {
            n2 += 256;
        }
        return n2;
    }

    public boolean isExplicit() {
        return (this.flags & 2) == 2;
    }

    public boolean isNoCollapse() {
        return (this.flags & 4) == 4;
    }

    public boolean isReserved() {
        return (this.flags & 1) == 1;
    }

    public static int translateColor(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = 0;
        if (color instanceof GDIColor) {
            GDIColor gDIColor = (GDIColor)color;
            n4 = gDIColor.getFlags();
        }
        int n5 = n4;
        n5 = (n5 << 8) + n3;
        n5 = (n5 << 8) + n2;
        n5 = (n5 << 8) + n;
        return n5;
    }
}

