/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.jfree.pixie.wmf.MfLogBrush;
import org.jfree.pixie.wmf.MfLogFont;
import org.jfree.pixie.wmf.MfLogPalette;
import org.jfree.pixie.wmf.MfLogPen;
import org.jfree.pixie.wmf.MfLogRegion;
import org.jfree.pixie.wmf.WmfFile;

public class MfDcState
implements Cloneable {
    private int viewportOrgX = 0;
    private int viewportOrgY = 0;
    private int viewportExtX = 1;
    private int viewportExtY = 1;
    private int windowExtX = 1;
    private int windowExtY = 1;
    private MfScale viewportScale;
    private MfScale windowScale;
    private int curPosX = 0;
    private int curPosY = 0;
    private Color fgColor;
    private Color bkColor;
    private Color textColor;
    private int textAlign = 0;
    private int textCharExtra;
    private int breakCount;
    private int extraSpaceLength;
    private int bkmode;
    private MfLogBrush logBrush;
    private MfLogPen logPen;
    private MfLogFont logFont;
    private MfLogRegion logRegion;
    private MfLogPalette logPalette;
    private int polyFillMode;
    private int rop;
    private int mapMode;
    private int mapperFlag;
    private int stretchBltMode;
    private Rectangle clipRegion;
    private WmfFile parent;

    public MfDcState(MfDcState mfDcState) {
        this.parent = mfDcState.parent;
        this.windowExtX = mfDcState.windowExtX;
        this.windowExtY = mfDcState.windowExtY;
        this.viewportOrgX = mfDcState.viewportOrgX;
        this.viewportOrgY = mfDcState.viewportOrgY;
        this.viewportExtX = mfDcState.viewportExtX;
        this.viewportExtY = mfDcState.viewportExtY;
        this.curPosX = mfDcState.curPosX;
        this.curPosY = mfDcState.curPosY;
        this.fgColor = mfDcState.fgColor;
        this.bkColor = mfDcState.bkColor;
        this.textAlign = mfDcState.textAlign;
        this.textCharExtra = mfDcState.textCharExtra;
        this.textColor = mfDcState.textColor;
        this.logBrush = mfDcState.logBrush;
        this.logPen = mfDcState.logPen;
        this.logFont = mfDcState.logFont;
        this.mapMode = mfDcState.mapMode;
        this.mapperFlag = mfDcState.mapperFlag;
        this.stretchBltMode = mfDcState.stretchBltMode;
        this.viewportScale = mfDcState.viewportScale;
        this.windowScale = mfDcState.windowScale;
        this.polyFillMode = mfDcState.polyFillMode;
        this.rop = mfDcState.rop;
        this.bkmode = mfDcState.bkmode;
        this.breakCount = mfDcState.breakCount;
        this.extraSpaceLength = mfDcState.extraSpaceLength;
        this.clipRegion = new Rectangle(mfDcState.clipRegion);
    }

    public MfDcState(WmfFile wmfFile) {
        this.fgColor = Color.black;
        this.bkColor = Color.white;
        this.textColor = Color.black;
        this.logBrush = new MfLogBrush();
        this.logPen = new MfLogPen();
        this.parent = wmfFile;
    }

    public Color getBkColor() {
        return this.bkColor;
    }

    public int getBkMode() {
        return this.bkmode;
    }

    public int getBreakCount() {
        return this.breakCount;
    }

    public Rectangle getClipRegion() {
        if (this.clipRegion == null) {
            return new Rectangle(this.viewportOrgX, this.viewportOrgY, this.viewportExtX, this.viewportExtY);
        }
        return this.clipRegion;
    }

    public int getCurPosX() {
        return this.curPosX;
    }

    public int getCurPosY() {
        return this.curPosY;
    }

    public int getExtraSpaceLength() {
        return this.extraSpaceLength;
    }

    public Color getFgColor() {
        return this.fgColor;
    }

    public int getHorizontalTextAlignment() {
        return this.textAlign & 0x18;
    }

    public MfLogBrush getLogBrush() {
        return this.logBrush;
    }

    public MfLogFont getLogFont() {
        return this.logFont;
    }

    public MfLogPalette getLogPalette() {
        return this.logPalette;
    }

    public MfLogPen getLogPen() {
        return this.logPen;
    }

    public MfLogRegion getLogRegion() {
        return this.logRegion;
    }

    public int getMapMode() {
        return this.mapMode;
    }

    public int getMapperFlag() {
        return this.mapperFlag;
    }

    public int getPhysicalX(int n) {
        return n + this.viewportOrgX;
    }

    public int getPhysicalY(int n) {
        return n + this.viewportOrgY;
    }

    public int getPolyFillMode() {
        return this.polyFillMode;
    }

    public int getROP() {
        return this.rop;
    }

    public int getStretchBltMode() {
        return this.stretchBltMode;
    }

    public int getTextAlign() {
        return this.textAlign;
    }

    public int getTextCharExtra() {
        return this.textCharExtra;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public int getVerticalTextAlignment() {
        return this.textAlign & 6;
    }

    public int getViewportExtX() {
        return this.viewportExtX;
    }

    public int getViewportExtY() {
        return this.viewportExtY;
    }

    public int getViewportOrgX() {
        return this.viewportOrgX;
    }

    public int getViewportOrgY() {
        return this.viewportOrgY;
    }

    public int getWindowExtX() {
        return this.windowExtX;
    }

    public int getWindowExtY() {
        return this.windowExtY;
    }

    public int getWindowOrgX() {
        return this.viewportOrgX;
    }

    public int getWindowOrgY() {
        return this.viewportOrgY;
    }

    public void postDraw() {
        this.parent.getGraphics2D().setPaint(this.logBrush.getPaint());
    }

    public void postDrawText() {
        this.parent.getGraphics2D().setPaint(this.logBrush.getPaint());
    }

    public void postPaint() {
    }

    public void prepareDraw() {
        this.parent.getGraphics2D().setPaint(this.logPen.getColor());
    }

    public void prepareDrawText() {
        this.parent.getGraphics2D().setPaint(this.textColor);
        this.parent.getGraphics2D().setFont(this.logFont.createFont());
    }

    public void preparePaint() {
        this.parent.getGraphics2D().setPaint(this.logBrush.getPaint());
    }

    public void restoredState() {
        Graphics2D graphics2D = this.parent.getGraphics2D();
        if (this.logBrush != null) {
            this.updateBrushBackground();
            graphics2D.setPaint(this.logBrush.getPaint());
        }
        if (this.logPen != null) {
            graphics2D.setStroke(this.logPen.getStroke());
        }
        if (this.logFont != null) {
            graphics2D.setFont(this.logFont.createFont());
        }
    }

    public void setBkColor(Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        this.bkColor = color;
        this.logBrush.setBackgroundColor(color);
    }

    public void setBkMode(int n) {
        if (this.bkmode != n) {
            this.bkmode = n;
            this.updateBrushBackground();
        }
    }

    public void setClipRegion(Rectangle rectangle) {
        this.clipRegion = rectangle;
    }

    public void setCurPos(int n, int n2) {
        this.curPosY = n2;
        this.curPosX = n;
    }

    public void setFgColor(Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        this.fgColor = color;
        this.logBrush.setColor(color);
        this.logPen.setColor(color);
    }

    public void setLogBrush(MfLogBrush mfLogBrush) {
        if (mfLogBrush == null) {
            throw new NullPointerException();
        }
        this.logBrush = mfLogBrush;
        this.updateBrushBackground();
        this.parent.getGraphics2D().setPaint(mfLogBrush.getPaint());
    }

    public void setLogFont(MfLogFont mfLogFont) {
        if (mfLogFont == null) {
            throw new NullPointerException();
        }
        this.logFont = mfLogFont;
    }

    public void setLogPalette(MfLogPalette mfLogPalette) {
        if (mfLogPalette == null) {
            throw new NullPointerException();
        }
        this.logPalette = mfLogPalette;
    }

    public void setLogPen(MfLogPen mfLogPen) {
        if (mfLogPen == null) {
            throw new NullPointerException();
        }
        this.logPen = mfLogPen;
        this.parent.getGraphics2D().setStroke(mfLogPen.getStroke());
    }

    public void setLogRegion(MfLogRegion mfLogRegion) {
        if (mfLogRegion == null) {
            throw new NullPointerException();
        }
        this.logRegion = mfLogRegion;
    }

    public void setMapMode(int n) {
        this.mapMode = n;
    }

    public void setMapperFlag(int n) {
        this.mapperFlag = n;
    }

    public void setPolyFillMode(int n) {
        this.polyFillMode = n;
    }

    public void setROP(int n) {
        this.rop = n;
    }

    public void setStretchBltMode(int n) {
        this.stretchBltMode = n;
    }

    public void setTextAlign(int n) {
        this.textAlign = n;
    }

    public void setTextCharExtra(int n) {
        this.textCharExtra = n;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public void setTextJustification(int n, int n2) {
        this.breakCount = n;
        this.extraSpaceLength = n2;
    }

    public void setViewportExt(int n, int n2) {
        this.viewportExtY = n2;
        this.viewportExtX = n;
    }

    public void setViewportOrg(int n, int n2) {
        this.viewportOrgX = n;
        this.viewportOrgY = n2;
    }

    public void setWindowExt(int n, int n2) {
        this.windowExtY = n2;
        this.windowExtX = n;
    }

    public void setWindowOrg(int n, int n2) {
        this.viewportOrgY = -n2;
        this.viewportOrgX = -n;
    }

    private void updateBrushBackground() {
        if (this.bkmode == 1) {
            this.logBrush.setBackgroundColor(new Color(0xFFFFFF, true));
        } else {
            this.logBrush.setBackgroundColor(this.getBkColor());
        }
    }

    public class MfScale {
        private int yNum;
        private int xNum;
        private int yDenom;
        private int xDenom;

        public MfScale(int n, int n2, int n3, int n4) {
            if (n == 0 || n3 == 0 || n2 == 0 || n4 == 0) {
                throw new IllegalArgumentException("Illegal Scaling");
            }
            this.xNum = n;
            this.yNum = n3;
            this.xDenom = n2;
            this.yDenom = n4;
        }

        public int scaleX(int n) {
            return n * this.xNum / this.xDenom;
        }

        public int scaleY(int n) {
            return n * this.yNum / this.yDenom;
        }
    }
}

