/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import org.jfree.pixie.wmf.Buffer;

public class MfHeader
extends Buffer {
    public static final int QUALITY_NO = 0;
    public static final int QUALITY_MAYBE = 1;
    public static final int QUALITY_YES = 2;
    private static final int PLACEABLE_HEADER_SIZE = 22;
    private static final int STANDARD_HEADER_SIZE = 18;
    private static final int WMF_FILE_TYPE = 22;
    private static final int WMF_HEADER_SIZE = 24;
    private static final int WMF_FILE_SIZE = 28;
    private static final int WMF_NUM_OF_REC = 32;
    private static final int WMF_MAX_REC_SIZE = 34;
    private static final int WMF_TYPE_MEM = 0;
    private static final int ALDUS_MAGIC_NUMBER_VAL = -1698247209;
    private static final int ALDUS_MAGIC_NUMBER_POS = 0;
    private static final int ALDUS_POS_LEFT = 6;
    private static final int ALDUS_POS_TOP = 8;
    private static final int ALDUS_POS_RIGHT = 10;
    private static final int ALDUS_POS_BOTTOM = 12;
    private static final int ALDUS_RESOLUTION = 14;

    public Rectangle getBBox() {
        int n = this.getShort(6);
        int n2 = this.getShort(8);
        int n3 = this.getShort(10);
        int n4 = this.getShort(12);
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    public int getFileSize() {
        return this.getInt(28) * 2;
    }

    public int getHeaderSize() {
        if (this.isPlaceable()) {
            return 40;
        }
        return 18;
    }

    public int getMaxRecordSize() {
        return this.getInt(34) * 2;
    }

    public int getObjectsSize() {
        return this.getShort(32);
    }

    public int getUnitsPerInch() {
        return this.getShort(14);
    }

    public static int isMetafile(String string, InputStream inputStream) {
        block10: {
            if (inputStream == null) break block10;
            MfHeader mfHeader = new MfHeader();
            try {
                try {
                    inputStream.mark(40);
                    mfHeader.read(inputStream);
                }
                catch (IOException iOException) {
                    mfHeader = null;
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    inputStream.reset();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.reset();
            }
            catch (IOException iOException) {}
            if (mfHeader == null || !mfHeader.isValid()) {
                return 0;
            }
            if (mfHeader.isPlaceable()) {
                return 2;
            }
        }
        if (string.regionMatches(true, string.length() - 4, ".wmf", 0, 4)) {
            return 1;
        }
        return 0;
    }

    private boolean isPlaceable() {
        return this.getInt(0) == -1698247209;
    }

    public boolean isValid() {
        int n = this.getShort(22);
        if (n == 0) {
            return false;
        }
        return this.getShort(24) == 9;
    }

    public void read(InputStream inputStream) throws IOException {
        int n = 40;
        this.setCapacity(40);
        this.read(inputStream, 0, 4);
        if (this.isPlaceable()) {
            this.read(inputStream, 4, 36);
        } else {
            this.move(0, 22, 4);
            this.read(inputStream, 26, 14);
        }
    }
}

