/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import org.jfree.pixie.wmf.GDIColor;
import org.jfree.pixie.wmf.WmfObject;

public class MfLogBrush
implements WmfObject {
    private static final boolean WHITE = false;
    private static final boolean BLACK = true;
    private static final boolean[] IMG_HS_HORIZONTAL;
    private static final boolean[] IMG_HS_VERTICAL;
    private static final boolean[] IMG_HS_FDIAGONAL;
    private static final boolean[] IMG_HS_BDIAGONAL;
    private static final boolean[] IMG_HS_CROSS;
    private static final boolean[] IMG_HS_DIAGCROSS;
    public static final int COLOR_FULL_ALPHA = 0xFFFFFF;
    public static final int BS_SOLID = 0;
    public static final int BS_NULL = 1;
    public static final int BS_HATCHED = 2;
    public static final int BS_PATTERN = 3;
    public static final int BS_INDEXED = 4;
    public static final int BS_DIBPATTERN = 5;
    public static final int HS_HORIZONTAL = 0;
    public static final int HS_VERTICAL = 1;
    public static final int HS_FDIAGONAL = 2;
    public static final int HS_BDIAGONAL = 3;
    public static final int HS_CROSS = 4;
    public static final int HS_DIAGCROSS = 5;
    private int style = 0;
    private Color color = Color.white;
    private Color bgColor = new Color(0xFFFFFF);
    private int hatch = 0;
    private Paint lastPaint;
    private BufferedImage bitmap;

    static {
        boolean[] blArray = new boolean[64];
        blArray[24] = true;
        blArray[25] = true;
        blArray[26] = true;
        blArray[27] = true;
        blArray[28] = true;
        blArray[29] = true;
        blArray[30] = true;
        blArray[31] = true;
        blArray[32] = true;
        blArray[33] = true;
        blArray[34] = true;
        blArray[35] = true;
        blArray[36] = true;
        blArray[37] = true;
        blArray[38] = true;
        blArray[39] = true;
        IMG_HS_HORIZONTAL = blArray;
        boolean[] blArray2 = new boolean[64];
        blArray2[3] = true;
        blArray2[4] = true;
        blArray2[11] = true;
        blArray2[12] = true;
        blArray2[19] = true;
        blArray2[20] = true;
        blArray2[27] = true;
        blArray2[28] = true;
        blArray2[35] = true;
        blArray2[36] = true;
        blArray2[43] = true;
        blArray2[44] = true;
        blArray2[51] = true;
        blArray2[52] = true;
        blArray2[59] = true;
        blArray2[60] = true;
        IMG_HS_VERTICAL = blArray2;
        boolean[] blArray3 = new boolean[64];
        blArray3[0] = true;
        blArray3[1] = true;
        blArray3[9] = true;
        blArray3[10] = true;
        blArray3[18] = true;
        blArray3[19] = true;
        blArray3[27] = true;
        blArray3[28] = true;
        blArray3[36] = true;
        blArray3[37] = true;
        blArray3[45] = true;
        blArray3[46] = true;
        blArray3[54] = true;
        blArray3[55] = true;
        blArray3[56] = true;
        blArray3[63] = true;
        IMG_HS_FDIAGONAL = blArray3;
        boolean[] blArray4 = new boolean[64];
        blArray4[0] = true;
        blArray4[7] = true;
        blArray4[14] = true;
        blArray4[15] = true;
        blArray4[21] = true;
        blArray4[22] = true;
        blArray4[28] = true;
        blArray4[29] = true;
        blArray4[35] = true;
        blArray4[36] = true;
        blArray4[42] = true;
        blArray4[43] = true;
        blArray4[49] = true;
        blArray4[50] = true;
        blArray4[56] = true;
        blArray4[57] = true;
        IMG_HS_BDIAGONAL = blArray4;
        boolean[] blArray5 = new boolean[64];
        blArray5[3] = true;
        blArray5[4] = true;
        blArray5[11] = true;
        blArray5[12] = true;
        blArray5[19] = true;
        blArray5[20] = true;
        blArray5[24] = true;
        blArray5[25] = true;
        blArray5[26] = true;
        blArray5[27] = true;
        blArray5[28] = true;
        blArray5[29] = true;
        blArray5[30] = true;
        blArray5[31] = true;
        blArray5[32] = true;
        blArray5[33] = true;
        blArray5[34] = true;
        blArray5[35] = true;
        blArray5[36] = true;
        blArray5[37] = true;
        blArray5[38] = true;
        blArray5[39] = true;
        blArray5[43] = true;
        blArray5[44] = true;
        blArray5[51] = true;
        blArray5[52] = true;
        blArray5[59] = true;
        blArray5[60] = true;
        IMG_HS_CROSS = blArray5;
        boolean[] blArray6 = new boolean[64];
        blArray6[0] = true;
        blArray6[1] = true;
        blArray6[6] = true;
        blArray6[7] = true;
        blArray6[9] = true;
        blArray6[10] = true;
        blArray6[13] = true;
        blArray6[14] = true;
        blArray6[18] = true;
        blArray6[19] = true;
        blArray6[20] = true;
        blArray6[21] = true;
        blArray6[27] = true;
        blArray6[28] = true;
        blArray6[34] = true;
        blArray6[35] = true;
        blArray6[36] = true;
        blArray6[37] = true;
        blArray6[41] = true;
        blArray6[42] = true;
        blArray6[45] = true;
        blArray6[46] = true;
        blArray6[48] = true;
        blArray6[49] = true;
        blArray6[54] = true;
        blArray6[55] = true;
        blArray6[56] = true;
        blArray6[63] = true;
        IMG_HS_DIAGCROSS = blArray6;
    }

    private BufferedImage createHatchStyle() {
        int n = this.getHatchedStyle();
        BufferedImage bufferedImage = new BufferedImage(8, 8, 2);
        switch (n) {
            case 0: {
                bufferedImage.setRGB(0, 0, 8, 8, this.transform(IMG_HS_HORIZONTAL), 0, 8);
                break;
            }
            case 1: {
                bufferedImage.setRGB(0, 0, 8, 8, this.transform(IMG_HS_VERTICAL), 0, 8);
                break;
            }
            case 2: {
                bufferedImage.setRGB(0, 0, 8, 8, this.transform(IMG_HS_FDIAGONAL), 0, 8);
                break;
            }
            case 3: {
                bufferedImage.setRGB(0, 0, 8, 8, this.transform(IMG_HS_BDIAGONAL), 0, 8);
                break;
            }
            case 4: {
                bufferedImage.setRGB(0, 0, 8, 8, this.transform(IMG_HS_CROSS), 0, 8);
                break;
            }
            case 5: {
                bufferedImage.setRGB(0, 0, 8, 8, this.transform(IMG_HS_DIAGCROSS), 0, 8);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return bufferedImage;
    }

    public Color getBackgroundColor() {
        return this.bgColor;
    }

    public Color getColor() {
        return this.color;
    }

    public int getHatchedStyle() {
        return this.hatch;
    }

    public Paint getPaint() {
        if (this.lastPaint != null) {
            return this.lastPaint;
        }
        switch (this.getStyle()) {
            case 0: {
                this.lastPaint = this.getColor();
                break;
            }
            case 1: {
                this.lastPaint = new GDIColor(0xFFFFFF);
            }
            case 2: {
                BufferedImage bufferedImage = this.createHatchStyle();
                this.lastPaint = new TexturePaint(bufferedImage, new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
                break;
            }
            case 5: {
                if (this.bitmap == null) {
                    this.lastPaint = new GDIColor(0xFFFFFF);
                    break;
                }
                this.lastPaint = new TexturePaint(this.bitmap, new Rectangle(0, 0, this.bitmap.getWidth(), this.bitmap.getHeight()));
                break;
            }
            default: {
                this.lastPaint = new GDIColor(0xFFFFFF);
            }
        }
        return this.lastPaint;
    }

    public int getStyle() {
        return this.style;
    }

    public int getType() {
        return 2;
    }

    public boolean isVisible() {
        return this.getStyle() != 1;
    }

    public void setBackgroundColor(Color color) {
        this.bgColor = color;
        this.lastPaint = null;
    }

    public void setBitmap(BufferedImage bufferedImage) {
        this.bitmap = bufferedImage;
    }

    public void setColor(Color color) {
        this.color = color;
        this.lastPaint = null;
    }

    public void setHatchedStyle(int n) {
        this.hatch = n;
        this.lastPaint = null;
    }

    public void setStyle(int n) {
        this.style = n;
    }

    public int[] transform(boolean[] blArray) {
        int n = this.getColor().getRGB();
        int n2 = this.getBackgroundColor().getRGB();
        int[] nArray = new int[blArray.length];
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[n3] = blArray[n3] ? n : n2;
            ++n3;
        }
        return nArray;
    }
}

