/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import org.jfree.pixie.wmf.PenConstants;
import org.jfree.pixie.wmf.WmfObject;

public class MfLogPen
implements WmfObject,
PenConstants {
    private int style = 0;
    private int endCap;
    private int joinType;
    private int width = 0;
    private Color color = Color.black;

    public Color getColor() {
        return this.color;
    }

    private float[] getDashes() {
        switch (this.getStyle()) {
            case 1: {
                return PenConstants.DASH_DASH;
            }
            case 2: {
                return PenConstants.DASH_DOT;
            }
            case 3: {
                return PenConstants.DASH_DASHDOT;
            }
            case 4: {
                return PenConstants.DASH_DASHDOTDOT;
            }
        }
        throw new IllegalStateException("Illegal Pen defined");
    }

    private int getEndCap() {
        switch (this.endCap) {
            case 0: {
                return 1;
            }
            case 256: {
                return 2;
            }
            case 512: {
                return 0;
            }
        }
        return 1;
    }

    private int getJoinType() {
        switch (this.joinType) {
            case 0: {
                return 1;
            }
            case 4096: {
                return 2;
            }
            case 8192: {
                return 0;
            }
        }
        return 1;
    }

    public Stroke getStroke() {
        if (this.isSimpleStyle()) {
            return new BasicStroke(this.getWidth(), this.getEndCap(), this.getJoinType(), 0.0f);
        }
        return new BasicStroke(this.getWidth(), this.getEndCap(), this.getJoinType(), 0.0f, this.getDashes(), 0.0f);
    }

    public int getStyle() {
        return this.style;
    }

    public int getType() {
        return 1;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isSimpleStyle() {
        switch (this.style) {
            case 0: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public boolean isVisible() {
        return this.getStyle() != 5;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setStyle(int n) {
        this.style = n & 0xFF;
        this.endCap = n & 0xF00;
        this.joinType = n & 0xF000;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MfLogPen:=");
        stringBuffer.append(" width=");
        stringBuffer.append(this.getWidth());
        stringBuffer.append(" style=");
        stringBuffer.append(this.getStyle());
        stringBuffer.append(" color=");
        stringBuffer.append(this.getColor());
        return stringBuffer.toString();
    }
}

