/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Stack;
import org.jfree.pixie.wmf.MfDcState;
import org.jfree.pixie.wmf.MfHeader;
import org.jfree.pixie.wmf.MfLogBrush;
import org.jfree.pixie.wmf.MfLogPen;
import org.jfree.pixie.wmf.MfLogRegion;
import org.jfree.pixie.wmf.MfPalette;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfObject;
import org.jfree.pixie.wmf.records.CommandFactory;
import org.jfree.pixie.wmf.records.MfCmd;
import org.jfree.pixie.wmf.records.MfCmdSetWindowExt;
import org.jfree.pixie.wmf.records.MfCmdSetWindowOrg;
import org.jfree.ui.Drawable;

public class WmfFile
implements Drawable {
    public static final int QUALITY_NO = 0;
    public static final int QUALITY_MAYBE = 1;
    public static final int QUALITY_YES = 2;
    private static final int MAX_PICTURE_SIZE = WmfFile.getMaxPictureSize();
    private WmfObject[] objects;
    private Stack dcStack;
    private MfPalette palette;
    private String inName;
    private InputStream in;
    private MfHeader header;
    private int fileSize;
    private int filePos;
    private ArrayList records;
    private Graphics2D graphics;
    private int maxX = 0;
    private int maxY = 0;
    private int imageX = 0;
    private int imageY = 0;
    public int maxRec = 10000;

    public WmfFile(InputStream inputStream, String string, int n, int n2) throws FileNotFoundException, IOException {
        this.inName = string;
        this.in = inputStream;
        this.imageX = n;
        this.imageY = n2;
        this.records = new ArrayList();
        this.dcStack = new Stack();
        this.palette = new MfPalette();
        this.resetStates();
        this.readHeader();
        this.parseRecords();
    }

    public WmfFile(String string) throws IOException {
        this(string, -1, -1);
    }

    public WmfFile(String string, int n, int n2) throws FileNotFoundException, IOException {
        this(new BufferedInputStream(new FileInputStream(string)), string, n, n2);
    }

    public WmfFile(URL uRL) throws IOException {
        this(uRL, -1, -1);
    }

    public WmfFile(URL uRL, int n, int n2) throws IOException {
        this(new BufferedInputStream(uRL.openStream()), uRL.toString(), n, n2);
    }

    public void assertValid() {
        if (!(this.filePos >= 0 && this.filePos <= this.fileSize)) {
            throw new IllegalStateException("WmfFile is not valid");
        }
    }

    public void deleteObject(int n) {
        if (!(n >= 0 && n < this.objects.length)) {
            throw new IllegalArgumentException("Range violation");
        }
        this.objects[n] = null;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.scaleToFit((float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
        graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
        this.graphics = graphics2D;
        int n = 0;
        while (n < this.records.size()) {
            if (n > this.maxRec) break;
            try {
                MfCmd mfCmd = (MfCmd)this.records.get(n);
                mfCmd.setScale((float)this.imageX / (float)this.maxX, (float)this.imageY / (float)this.maxY);
                mfCmd.replay(this);
            }
            catch (Exception exception) {
                System.out.println("Error on records i = " + n);
                exception.printStackTrace();
            }
            ++n;
        }
        this.resetStates();
    }

    protected int findFreeSlot() {
        int n = 0;
        while (n < this.objects.length) {
            if (this.objects[n] == null) {
                return n;
            }
            ++n;
        }
        throw new IllegalStateException("No free slot");
    }

    public MfLogBrush getBrushObject(int n) {
        WmfObject wmfObject = this.getObject(n);
        if (wmfObject.getType() == 2) {
            return (MfLogBrush)wmfObject;
        }
        throw new IllegalStateException("Object " + n + " was no brush");
    }

    public MfDcState getCurrentState() {
        return (MfDcState)this.dcStack.peek();
    }

    public Graphics2D getGraphics2D() {
        return this.graphics;
    }

    public MfHeader getHeader() {
        return this.header;
    }

    private static int getMaxPictureSize() {
        return 1200;
    }

    public WmfObject getObject(int n) {
        if (!(n >= 0 && n < this.objects.length)) {
            throw new IllegalStateException("Range violation");
        }
        return this.objects[n];
    }

    public MfPalette getPalette() {
        return this.palette;
    }

    public MfLogPen getPenObject(int n) {
        WmfObject wmfObject = this.getObject(n);
        if (wmfObject.getType() == 1) {
            return (MfLogPen)wmfObject;
        }
        throw new IllegalStateException("Object " + n + " was no pen");
    }

    public MfLogRegion getRegionObject(int n) {
        WmfObject wmfObject = this.getObject(n);
        if (wmfObject.getType() == 5) {
            return (MfLogRegion)wmfObject;
        }
        throw new IllegalStateException("Object " + n + " was no region");
    }

    public int getStateCount() {
        return this.dcStack.size();
    }

    public static int isMetafile(String string, InputStream inputStream) {
        return MfHeader.isMetafile(string, inputStream);
    }

    public static void main(String[] stringArray) throws Exception {
        WmfFile wmfFile = new WmfFile("./pixie/res/test.wmf", 800, 600);
        wmfFile.replay();
    }

    protected void parseRecords() throws IOException {
        int n = 0;
        int n2 = 0;
        CommandFactory commandFactory = CommandFactory.getInstance();
        MfRecord mfRecord = null;
        while ((mfRecord = this.readNextRecord()) != null) {
            Cloneable cloneable;
            MfCmd mfCmd;
            MfCmd mfCmd2 = commandFactory.getCommand(mfRecord.getType());
            if (mfCmd2 == null) {
                System.out.println("Failed to parse record " + mfRecord.getType());
                continue;
            }
            mfCmd2.setRecord(mfRecord);
            if (mfCmd2.getFunction() == 523) {
                mfCmd = (MfCmdSetWindowOrg)mfCmd2;
                cloneable = ((MfCmdSetWindowOrg)mfCmd).getTarget();
                n = cloneable.x;
                n2 = cloneable.y;
            } else if (mfCmd2.getFunction() == 524) {
                mfCmd = (MfCmdSetWindowExt)mfCmd2;
                cloneable = ((MfCmdSetWindowExt)mfCmd).getDimension();
                this.maxX = Math.max(this.maxX, n + ((Dimension)cloneable).width);
                this.maxY = Math.max(this.maxY, n2 + ((Dimension)cloneable).height);
            }
            this.records.add(mfCmd2);
        }
        this.in.close();
        this.in = null;
        this.scaleToFit(MAX_PICTURE_SIZE, MAX_PICTURE_SIZE);
    }

    public MfHeader readHeader() throws IOException {
        this.header = new MfHeader();
        this.header.read(this.in);
        if (this.header.isValid()) {
            this.fileSize = this.header.getFileSize();
            this.objects = new WmfObject[this.header.getObjectsSize()];
            this.filePos = this.header.getHeaderSize();
            return this.header;
        }
        throw new IOException(String.valueOf(this.inName) + "is not a real metafile");
    }

    public MfRecord readNextRecord() throws IOException {
        if (this.filePos >= this.fileSize) {
            return null;
        }
        this.assertValid();
        MfRecord mfRecord = new MfRecord(this.in);
        this.filePos += mfRecord.getLength();
        return mfRecord;
    }

    public synchronized BufferedImage replay() {
        BufferedImage bufferedImage = new BufferedImage(this.imageX, this.imageY, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(new Color(0, 0, 0, 0));
        graphics2D.fill(new Rectangle(0, 0, this.imageX, this.imageY));
        this.draw(graphics2D, new Rectangle2D.Float(0.0f, 0.0f, this.imageX, this.imageY));
        graphics2D.dispose();
        graphics2D = null;
        return bufferedImage;
    }

    public void resetStates() {
        this.dcStack.clear();
        this.dcStack.push(new MfDcState(this));
    }

    public void restoreDCState(int n) {
        if (!(n > 0)) {
            throw new IllegalArgumentException();
        }
        if (this.dcStack.size() > 1 + n) {
            int n2 = 0;
            while (n2 < n) {
                this.dcStack.pop();
                ++n2;
            }
        } else {
            throw new EmptyStackException();
        }
        this.getCurrentState().restoredState();
    }

    public void saveDCState() {
        MfDcState mfDcState = this.getCurrentState();
        this.dcStack.push(new MfDcState(mfDcState));
    }

    public void scalePercent(float f) {
        this.scalePercent(f, f);
    }

    public void scalePercent(float f, float f2) {
        this.imageX = (int)((float)this.maxX * f / 100.0f);
        this.imageY = (int)((float)this.maxY * f2 / 100.0f);
    }

    public void scaleToFit(float f, float f2) {
        float f3 = f * 100.0f / (float)this.maxX;
        float f4 = f2 * 100.0f / (float)this.maxY;
        this.scalePercent(f3 < f4 ? f3 : f4);
    }

    public void storeObject(WmfObject wmfObject) {
        int n = this.findFreeSlot();
        this.objects[n] = wmfObject;
    }
}

