/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.bitmap;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.FileInputStream;
import java.io.IOException;

public class BitmapReader {
    public static double constructDouble(byte[] byArray, int n) {
        long l = BitmapReader.constructLong(byArray, n);
        return Double.longBitsToDouble(l);
    }

    public static int constructInt(byte[] byArray, int n) {
        int n2 = byArray[n + 3] & 0xFF;
        n2 = n2 << 8 | byArray[n + 2] & 0xFF;
        n2 = n2 << 8 | byArray[n + 1] & 0xFF;
        n2 = n2 << 8 | byArray[n] & 0xFF;
        return n2;
    }

    public static int constructInt3(byte[] byArray, int n) {
        int n2 = 255;
        n2 = n2 << 8 | byArray[n + 2] & 0xFF;
        n2 = n2 << 8 | byArray[n + 1] & 0xFF;
        n2 = n2 << 8 | byArray[n] & 0xFF;
        return n2;
    }

    public static long constructLong(byte[] byArray, int n) {
        long l = (long)byArray[n + 7] & 0xFFL;
        l |= l << 8 | (long)byArray[n + 6] & 0xFFL;
        l |= l << 8 | (long)byArray[n + 5] & 0xFFL;
        l |= l << 8 | (long)byArray[n + 4] & 0xFFL;
        l |= l << 8 | (long)byArray[n + 3] & 0xFFL;
        l |= l << 8 | (long)byArray[n + 2] & 0xFFL;
        l |= l << 8 | (long)byArray[n + 1] & 0xFFL;
        l |= l << 8 | (long)byArray[n] & 0xFFL;
        return l;
    }

    public static short constructShort(byte[] byArray, int n) {
        short s = (short)((short)byArray[n + 1] & 0xFF);
        s = (short)(s << 8 | (short)((short)byArray[n] & 0xFF));
        return s;
    }

    public static Image load(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            return BitmapReader.read(fileInputStream);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Image read(FileInputStream fileInputStream) {
        try {
            BitmapHeader bitmapHeader = new BitmapHeader();
            bitmapHeader.read(fileInputStream);
            if (bitmapHeader.nbitcount == 24) {
                return BitmapReader.readMap24(fileInputStream, bitmapHeader);
            }
            if (bitmapHeader.nbitcount == 32) {
                return BitmapReader.readMap32(fileInputStream, bitmapHeader);
            }
            if (bitmapHeader.nbitcount == 8) {
                return BitmapReader.readMap8(fileInputStream, bitmapHeader);
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {}
        return null;
    }

    protected static Image readMap24(FileInputStream fileInputStream, BitmapHeader bitmapHeader) throws IOException {
        int n = bitmapHeader.nsizeimage / bitmapHeader.nheight - bitmapHeader.nwidth * 3;
        int[] nArray = new int[bitmapHeader.nheight * bitmapHeader.nwidth];
        byte[] byArray = new byte[(bitmapHeader.nwidth + n) * 3 * bitmapHeader.nheight];
        fileInputStream.read(byArray, 0, (bitmapHeader.nwidth + n) * 3 * bitmapHeader.nheight);
        int n2 = 0;
        int n3 = 0;
        while (n3 < bitmapHeader.nheight) {
            int n4 = 0;
            while (n4 < bitmapHeader.nwidth) {
                nArray[bitmapHeader.nwidth * (bitmapHeader.nheight - n3 - 1) + n4] = BitmapReader.constructInt3(byArray, n2);
                n2 += 3;
                ++n4;
            }
            n2 += n;
            ++n3;
        }
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(bitmapHeader.nwidth, bitmapHeader.nheight, nArray, 0, bitmapHeader.nwidth));
        fileInputStream.close();
        return image;
    }

    protected static Image readMap32(FileInputStream fileInputStream, BitmapHeader bitmapHeader) throws IOException {
        int[] nArray = new int[bitmapHeader.nheight * bitmapHeader.nwidth];
        byte[] byArray = new byte[bitmapHeader.nwidth * 4 * bitmapHeader.nheight];
        fileInputStream.read(byArray, 0, bitmapHeader.nwidth * 4 * bitmapHeader.nheight);
        int n = 0;
        int n2 = 0;
        while (n2 < bitmapHeader.nheight) {
            int n3 = 0;
            while (n3 < bitmapHeader.nwidth) {
                nArray[bitmapHeader.nwidth * (bitmapHeader.nheight - n2 - 1) + n3] = BitmapReader.constructInt3(byArray, n);
                n += 4;
                ++n3;
            }
            ++n2;
        }
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(bitmapHeader.nwidth, bitmapHeader.nheight, nArray, 0, bitmapHeader.nwidth));
        fileInputStream.close();
        return image;
    }

    protected static Image readMap8(FileInputStream fileInputStream, BitmapHeader bitmapHeader) throws IOException {
        int n = 0;
        n = bitmapHeader.nclrused > 0 ? bitmapHeader.nclrused : 1 << bitmapHeader.nbitcount;
        if (bitmapHeader.nsizeimage == 0) {
            bitmapHeader.nsizeimage = (bitmapHeader.nwidth * bitmapHeader.nbitcount + 31 & 0xFFFFFFE0) >> 3;
            bitmapHeader.nsizeimage *= bitmapHeader.nheight;
        }
        int[] nArray = new int[n];
        byte[] byArray = new byte[n * 4];
        fileInputStream.read(byArray, 0, n * 4);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = BitmapReader.constructInt3(byArray, n2);
            n2 += 4;
            ++n3;
        }
        int n4 = bitmapHeader.nsizeimage / bitmapHeader.nheight - bitmapHeader.nwidth;
        int[] nArray2 = new int[bitmapHeader.nwidth * bitmapHeader.nheight];
        byte[] byArray2 = new byte[(bitmapHeader.nwidth + n4) * bitmapHeader.nheight];
        fileInputStream.read(byArray2, 0, (bitmapHeader.nwidth + n4) * bitmapHeader.nheight);
        n2 = 0;
        int n5 = 0;
        while (n5 < bitmapHeader.nheight) {
            int n6 = 0;
            while (n6 < bitmapHeader.nwidth) {
                nArray2[bitmapHeader.nwidth * (bitmapHeader.nheight - n5 - 1) + n6] = nArray[byArray2[n2] & 0xFF];
                ++n2;
                ++n6;
            }
            n2 += n4;
            ++n5;
        }
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(bitmapHeader.nwidth, bitmapHeader.nheight, nArray2, 0, bitmapHeader.nwidth));
        return image;
    }

    protected static class BitmapHeader {
        public int nsize;
        public int nbisize;
        public int nwidth;
        public int nheight;
        public int nplanes;
        public int nbitcount;
        public int ncompression;
        public int nsizeimage;
        public int nxpm;
        public int nypm;
        public int nclrused;
        public int nclrimp;

        protected BitmapHeader() {
        }

        public void read(FileInputStream fileInputStream) throws IOException {
            int n = 14;
            byte[] byArray = new byte[14];
            fileInputStream.read(byArray, 0, 14);
            int n2 = 40;
            byte[] byArray2 = new byte[40];
            fileInputStream.read(byArray2, 0, 40);
            this.nsize = BitmapReader.constructInt(byArray, 2);
            this.nbisize = BitmapReader.constructInt(byArray2, 2);
            this.nwidth = BitmapReader.constructInt(byArray2, 4);
            this.nheight = BitmapReader.constructInt(byArray2, 8);
            this.nplanes = BitmapReader.constructShort(byArray2, 12);
            this.nbitcount = BitmapReader.constructShort(byArray2, 14);
            this.ncompression = BitmapReader.constructInt(byArray2, 16);
            this.nsizeimage = BitmapReader.constructInt(byArray2, 20);
            this.nxpm = BitmapReader.constructInt(byArray2, 24);
            this.nypm = BitmapReader.constructInt(byArray2, 28);
            this.nclrused = BitmapReader.constructInt(byArray2, 32);
            this.nclrimp = BitmapReader.constructInt(byArray2, 36);
        }
    }
}

