/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.bitmap;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.bitmap.BitmapCompression;
import org.jfree.pixie.wmf.bitmap.BitmapCompressionFactory;
import org.jfree.pixie.wmf.bitmap.BitmapHeader;
import org.jfree.pixie.wmf.bitmap.GDIPalette;

public class DIBReader {
    private GDIPalette palette;
    private BitmapHeader header;

    public BufferedImage setRecord(MfRecord mfRecord) throws IOException {
        return this.setRecord(mfRecord, 0);
    }

    public BufferedImage setRecord(MfRecord mfRecord, int n) throws IOException {
        this.header = new BitmapHeader();
        this.header.setRecord(mfRecord, n);
        this.palette = new GDIPalette();
        this.palette.setNoOfColors(this.header.getNoOfColors());
        int n2 = this.header.getWidth();
        int n3 = this.header.getHeight();
        int n4 = MfRecord.RECORD_HEADER_SIZE + this.header.getHeaderSize() + 4 + n;
        InputStream inputStream = mfRecord.getInputStream(n4);
        this.palette.readPalette(inputStream);
        int n5 = this.header.getCompression();
        BitmapCompression bitmapCompression = BitmapCompressionFactory.getHandler(n5);
        bitmapCompression.setDimension(n2, n3);
        bitmapCompression.setBpp(this.header.getBitsPerPixel());
        int[] nArray = bitmapCompression.decompress(inputStream, this.palette);
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        bufferedImage.setRGB(0, 0, n2, n3, nArray, 0, n2);
        return bufferedImage;
    }
}

