/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.util.Hashtable;
import org.jfree.pixie.wmf.records.MfCmd;
import org.jfree.pixie.wmf.records.MfCmdAnimatePalette;
import org.jfree.pixie.wmf.records.MfCmdArc;
import org.jfree.pixie.wmf.records.MfCmdBitBlt;
import org.jfree.pixie.wmf.records.MfCmdChord;
import org.jfree.pixie.wmf.records.MfCmdCreateBrush;
import org.jfree.pixie.wmf.records.MfCmdCreateDibPatternBrush;
import org.jfree.pixie.wmf.records.MfCmdCreateFont;
import org.jfree.pixie.wmf.records.MfCmdCreatePalette;
import org.jfree.pixie.wmf.records.MfCmdCreatePatternBrush;
import org.jfree.pixie.wmf.records.MfCmdCreatePen;
import org.jfree.pixie.wmf.records.MfCmdCreateRegion;
import org.jfree.pixie.wmf.records.MfCmdDeleteObject;
import org.jfree.pixie.wmf.records.MfCmdDibBitBlt;
import org.jfree.pixie.wmf.records.MfCmdDibStretchBlt;
import org.jfree.pixie.wmf.records.MfCmdEllipse;
import org.jfree.pixie.wmf.records.MfCmdEscape;
import org.jfree.pixie.wmf.records.MfCmdExcludeClipRect;
import org.jfree.pixie.wmf.records.MfCmdExtFloodFill;
import org.jfree.pixie.wmf.records.MfCmdExtTextOut;
import org.jfree.pixie.wmf.records.MfCmdFillRegion;
import org.jfree.pixie.wmf.records.MfCmdFloodFill;
import org.jfree.pixie.wmf.records.MfCmdFrameRegion;
import org.jfree.pixie.wmf.records.MfCmdIntersectClipRect;
import org.jfree.pixie.wmf.records.MfCmdInvertRegion;
import org.jfree.pixie.wmf.records.MfCmdLineTo;
import org.jfree.pixie.wmf.records.MfCmdMoveTo;
import org.jfree.pixie.wmf.records.MfCmdOffsetClipRgn;
import org.jfree.pixie.wmf.records.MfCmdOffsetViewportOrg;
import org.jfree.pixie.wmf.records.MfCmdOffsetWindowOrg;
import org.jfree.pixie.wmf.records.MfCmdPaintRgn;
import org.jfree.pixie.wmf.records.MfCmdPatBlt;
import org.jfree.pixie.wmf.records.MfCmdPie;
import org.jfree.pixie.wmf.records.MfCmdPolyPolygon;
import org.jfree.pixie.wmf.records.MfCmdPolygon;
import org.jfree.pixie.wmf.records.MfCmdPolyline;
import org.jfree.pixie.wmf.records.MfCmdRealisePalette;
import org.jfree.pixie.wmf.records.MfCmdRectangle;
import org.jfree.pixie.wmf.records.MfCmdResizePalette;
import org.jfree.pixie.wmf.records.MfCmdRestoreDc;
import org.jfree.pixie.wmf.records.MfCmdRoundRect;
import org.jfree.pixie.wmf.records.MfCmdSaveDc;
import org.jfree.pixie.wmf.records.MfCmdScaleViewportExt;
import org.jfree.pixie.wmf.records.MfCmdScaleWindowExt;
import org.jfree.pixie.wmf.records.MfCmdSelectClipRegion;
import org.jfree.pixie.wmf.records.MfCmdSelectObject;
import org.jfree.pixie.wmf.records.MfCmdSelectPalette;
import org.jfree.pixie.wmf.records.MfCmdSetBkColor;
import org.jfree.pixie.wmf.records.MfCmdSetBkMode;
import org.jfree.pixie.wmf.records.MfCmdSetDibitsToDevice;
import org.jfree.pixie.wmf.records.MfCmdSetMapMode;
import org.jfree.pixie.wmf.records.MfCmdSetMapperFlags;
import org.jfree.pixie.wmf.records.MfCmdSetPaletteEntries;
import org.jfree.pixie.wmf.records.MfCmdSetPixel;
import org.jfree.pixie.wmf.records.MfCmdSetPolyFillMode;
import org.jfree.pixie.wmf.records.MfCmdSetRop2;
import org.jfree.pixie.wmf.records.MfCmdSetStretchBltMode;
import org.jfree.pixie.wmf.records.MfCmdSetTextAlign;
import org.jfree.pixie.wmf.records.MfCmdSetTextCharExtra;
import org.jfree.pixie.wmf.records.MfCmdSetTextColor;
import org.jfree.pixie.wmf.records.MfCmdSetTextJustification;
import org.jfree.pixie.wmf.records.MfCmdSetViewPortExt;
import org.jfree.pixie.wmf.records.MfCmdSetViewPortOrg;
import org.jfree.pixie.wmf.records.MfCmdSetWindowExt;
import org.jfree.pixie.wmf.records.MfCmdSetWindowOrg;
import org.jfree.pixie.wmf.records.MfCmdStretchBlt;
import org.jfree.pixie.wmf.records.MfCmdStretchDibits;
import org.jfree.pixie.wmf.records.MfCmdTextOut;
import org.jfree.pixie.wmf.records.MfCmdUnknownCommand;

public class CommandFactory {
    private static CommandFactory commandFactory;
    private Hashtable recordTypes;

    public MfCmd getCommand(int n) {
        MfCmd mfCmd;
        if (this.recordTypes == null) {
            this.registerAllKnownTypes();
        }
        if ((mfCmd = (MfCmd)this.recordTypes.get(new Integer(n))) == null) {
            MfCmdUnknownCommand mfCmdUnknownCommand = new MfCmdUnknownCommand();
            mfCmdUnknownCommand.setFunction(n);
            return mfCmdUnknownCommand;
        }
        return mfCmd.getInstance();
    }

    public static CommandFactory getInstance() {
        if (commandFactory == null) {
            commandFactory = new CommandFactory();
        }
        return commandFactory;
    }

    public void registerAllKnownTypes() {
        if (this.recordTypes != null) {
            return;
        }
        this.recordTypes = new Hashtable();
        this.registerCommand(new MfCmdAnimatePalette());
        this.registerCommand(new MfCmdArc());
        this.registerCommand(new MfCmdDibBitBlt());
        this.registerCommand(new MfCmdChord());
        this.registerCommand(new MfCmdCreateBrush());
        this.registerCommand(new MfCmdCreateDibPatternBrush());
        this.registerCommand(new MfCmdCreateFont());
        this.registerCommand(new MfCmdCreatePen());
        this.registerCommand(new MfCmdCreatePalette());
        this.registerCommand(new MfCmdCreatePatternBrush());
        this.registerCommand(new MfCmdCreateRegion());
        this.registerCommand(new MfCmdDeleteObject());
        this.registerCommand(new MfCmdEllipse());
        this.registerCommand(new MfCmdEscape());
        this.registerCommand(new MfCmdExcludeClipRect());
        this.registerCommand(new MfCmdExtFloodFill());
        this.registerCommand(new MfCmdExtTextOut());
        this.registerCommand(new MfCmdFillRegion());
        this.registerCommand(new MfCmdFrameRegion());
        this.registerCommand(new MfCmdFloodFill());
        this.registerCommand(new MfCmdInvertRegion());
        this.registerCommand(new MfCmdIntersectClipRect());
        this.registerCommand(new MfCmdLineTo());
        this.registerCommand(new MfCmdMoveTo());
        this.registerCommand(new MfCmdOffsetClipRgn());
        this.registerCommand(new MfCmdOffsetViewportOrg());
        this.registerCommand(new MfCmdOffsetWindowOrg());
        this.registerCommand(new MfCmdBitBlt());
        this.registerCommand(new MfCmdStretchBlt());
        this.registerCommand(new MfCmdPatBlt());
        this.registerCommand(new MfCmdPaintRgn());
        this.registerCommand(new MfCmdPie());
        this.registerCommand(new MfCmdPolyPolygon());
        this.registerCommand(new MfCmdPolygon());
        this.registerCommand(new MfCmdPolyline());
        this.registerCommand(new MfCmdRealisePalette());
        this.registerCommand(new MfCmdRectangle());
        this.registerCommand(new MfCmdRestoreDc());
        this.registerCommand(new MfCmdResizePalette());
        this.registerCommand(new MfCmdRoundRect());
        this.registerCommand(new MfCmdSaveDc());
        this.registerCommand(new MfCmdScaleWindowExt());
        this.registerCommand(new MfCmdScaleViewportExt());
        this.registerCommand(new MfCmdSelectClipRegion());
        this.registerCommand(new MfCmdSelectObject());
        this.registerCommand(new MfCmdSelectPalette());
        this.registerCommand(new MfCmdSetBkMode());
        this.registerCommand(new MfCmdSetBkColor());
        this.registerCommand(new MfCmdSetDibitsToDevice());
        this.registerCommand(new MfCmdSetMapperFlags());
        this.registerCommand(new MfCmdSetMapMode());
        this.registerCommand(new MfCmdSetPaletteEntries());
        this.registerCommand(new MfCmdSetPolyFillMode());
        this.registerCommand(new MfCmdSetPixel());
        this.registerCommand(new MfCmdSetRop2());
        this.registerCommand(new MfCmdSetStretchBltMode());
        this.registerCommand(new MfCmdSetTextCharExtra());
        this.registerCommand(new MfCmdSetTextAlign());
        this.registerCommand(new MfCmdSetTextColor());
        this.registerCommand(new MfCmdSetTextJustification());
        this.registerCommand(new MfCmdSetViewPortExt());
        this.registerCommand(new MfCmdSetViewPortOrg());
        this.registerCommand(new MfCmdSetWindowExt());
        this.registerCommand(new MfCmdSetWindowOrg());
        this.registerCommand(new MfCmdDibStretchBlt());
        this.registerCommand(new MfCmdStretchDibits());
        this.registerCommand(new MfCmdTextOut());
    }

    private void registerCommand(MfCmd mfCmd) {
        if (this.recordTypes.get(new Integer(mfCmd.getFunction())) != null) {
            throw new IllegalArgumentException("Already registered");
        }
        this.recordTypes.put(new Integer(mfCmd.getFunction()), mfCmd);
    }
}

