/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Color;
import org.jfree.pixie.wmf.GDIColor;
import org.jfree.pixie.wmf.MfLogPalette;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;
import org.jfree.pixie.wmf.records.RecordCreationException;

public class MfCmdCreatePalette
extends MfCmd {
    private static final int POS_HPALETTE = 0;
    private static final int POS_CENTRIES = 1;
    private static final int POS_START_ENTRIES = 2;
    private int hPalette;
    private Color[] colors;

    public Color[] getEntries() {
        return this.colors;
    }

    public int getEntriesCount() {
        if (this.colors == null) {
            return 0;
        }
        return this.colors.length;
    }

    public int getFunction() {
        return 247;
    }

    public int getHPalette() {
        return this.hPalette;
    }

    public MfCmd getInstance() {
        return new MfCmdCreatePalette();
    }

    public MfRecord getRecord() throws RecordCreationException {
        int n = this.getEntriesCount();
        if (n == 0) {
            throw new RecordCreationException("Empty CreatePaletteRecord is not valid");
        }
        MfRecord mfRecord = new MfRecord(2 + n * 2);
        mfRecord.setParam(0, this.getHPalette());
        mfRecord.setParam(1, n);
        Color[] colorArray = new Color[n];
        int n2 = 0;
        while (n2 < n) {
            Color color = colorArray[n2];
            mfRecord.setLongParam(n2 * 2 + 2, GDIColor.translateColor(color));
            ++n2;
        }
        return mfRecord;
    }

    public void replay(WmfFile wmfFile) {
        MfLogPalette mfLogPalette = new MfLogPalette();
        wmfFile.getCurrentState().setLogPalette(mfLogPalette);
        wmfFile.storeObject(mfLogPalette);
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }

    public void setEntries(Color[] colorArray) {
        this.colors = colorArray;
    }

    public void setHPalette(int n) {
        this.hPalette = n;
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(0);
        this.setHPalette(n);
        int n2 = mfRecord.getParam(1);
        Color[] colorArray = new Color[n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = mfRecord.getLongParam(n3 * 2 + 2);
            GDIColor gDIColor = new GDIColor(n4);
            colorArray[n3] = gDIColor;
            ++n3;
        }
        this.setEntries(colorArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CREATE_PALETTE] ");
        stringBuffer.append(" no internals known ");
        return stringBuffer.toString();
    }
}

