/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Color;
import org.jfree.pixie.wmf.GDIColor;
import org.jfree.pixie.wmf.MfLogPen;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;

public class MfCmdCreatePen
extends MfCmd {
    private static final int RECORD_SIZE = 4;
    private static final int POS_STYLE = 0;
    private static final int POS_WIDTH = 1;
    private static final int POS_COLOR = 2;
    private int style;
    private Color color;
    private int width;
    private int scaled_width;

    public Color getColor() {
        return this.color;
    }

    public int getFunction() {
        return 762;
    }

    public MfCmd getInstance() {
        return new MfCmdCreatePen();
    }

    public MfRecord getRecord() {
        MfRecord mfRecord = new MfRecord(4);
        mfRecord.setParam(0, this.getStyle());
        mfRecord.setParam(1, this.getWidth());
        mfRecord.setLongParam(2, GDIColor.translateColor(this.getColor()));
        return mfRecord;
    }

    public int getScaledWidth() {
        return this.scaled_width;
    }

    public int getStyle() {
        return this.style;
    }

    public int getWidth() {
        return this.width;
    }

    public void replay(WmfFile wmfFile) {
        MfLogPen mfLogPen = new MfLogPen();
        mfLogPen.setStyle(this.getStyle());
        mfLogPen.setColor(this.getColor());
        mfLogPen.setWidth(this.getScaledWidth());
        wmfFile.getCurrentState().setLogPen(mfLogPen);
        wmfFile.storeObject(mfLogPen);
    }

    protected void scaleXChanged() {
        this.scaled_width = this.getScaledX(this.width);
    }

    protected void scaleYChanged() {
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(0);
        int n2 = mfRecord.getParam(1);
        int n3 = mfRecord.getLongParam(2);
        this.setStyle(n);
        this.setWidth(n2);
        this.setColor(new GDIColor(n3));
    }

    public void setStyle(int n) {
        this.style = n;
    }

    public void setWidth(int n) {
        this.width = n;
        this.scaleXChanged();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CREATE_PEN] style=");
        stringBuffer.append(this.getStyle());
        stringBuffer.append(" width=");
        stringBuffer.append(this.getWidth());
        stringBuffer.append(" color=");
        stringBuffer.append(this.getColor());
        return stringBuffer.toString();
    }
}

