/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.ROPConstants;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.bitmap.DIBReader;
import org.jfree.pixie.wmf.records.MfCmd;
import org.jfree.pixie.wmf.records.RecordCreationException;

public class MfCmdDibBitBlt
extends MfCmd
implements ROPConstants {
    private static final int RECORD_SIZE_SIMPLE = 9;
    private static final int RECORD_BASE_SIZE_EXT = 8;
    private static final int POS_OPERATION = 0;
    private static final int POS_SRC_Y = 2;
    private static final int POS_SRC_X = 3;
    private static final int SIMPLE_POS_HEIGHT = 5;
    private static final int SIMPLE_POS_WIDTH = 6;
    private static final int SIMPLE_POS_DST_Y = 7;
    private static final int SIMPLE_POS_DST_X = 8;
    private static final int EXT_POS_HEIGHT = 4;
    private static final int EXT_POS_WIDTH = 5;
    private static final int EXT_POS_DST_Y = 6;
    private static final int EXT_POS_DST_X = 7;
    private BufferedImage image;
    private int scaled_destX;
    private int scaled_destY;
    private int scaled_destWidth;
    private int scaled_destHeight;
    private int scaled_sourceX;
    private int scaled_sourceY;
    private int destX;
    private int destY;
    private int destWidth;
    private int destHeight;
    private int sourceX;
    private int sourceY;
    private int operation;

    public Rectangle getDestination() {
        return new Rectangle(this.destX, this.destY, this.destWidth, this.destHeight);
    }

    public int getFunction() {
        return 2368;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public MfCmd getInstance() {
        return new MfCmdDibBitBlt();
    }

    public int getOperation() {
        return this.operation;
    }

    public Point getOrigin() {
        return new Point(this.sourceX, this.sourceY);
    }

    public MfRecord getRecord() throws RecordCreationException {
        if (this.image == null) {
            MfRecord mfRecord = new MfRecord(9);
            mfRecord.setLongParam(0, this.getOperation());
            Rectangle rectangle = this.getSource();
            mfRecord.setParam(2, (int)rectangle.getY());
            mfRecord.setParam(3, (int)rectangle.getX());
            Rectangle rectangle2 = this.getDestination();
            mfRecord.setParam(4, 0);
            mfRecord.setParam(5, (int)rectangle2.getHeight());
            mfRecord.setParam(6, (int)rectangle2.getWidth());
            mfRecord.setParam(7, (int)rectangle2.getY());
            mfRecord.setParam(8, (int)rectangle2.getX());
            return mfRecord;
        }
        throw new RecordCreationException("The extended Format of DibBitBlt is not supported");
    }

    public Rectangle getScaledDestination() {
        return new Rectangle(this.scaled_destX, this.scaled_destY, this.scaled_destWidth, this.scaled_destHeight);
    }

    public Point getScaledOrigin() {
        return new Point(this.scaled_sourceX, this.scaled_sourceY);
    }

    public Rectangle getScaledSource() {
        return new Rectangle(this.scaled_sourceX, this.scaled_sourceY, this.scaled_destWidth, this.scaled_destHeight);
    }

    public Rectangle getSource() {
        return new Rectangle(this.sourceX, this.sourceY, this.destWidth, this.destHeight);
    }

    public void replay(WmfFile wmfFile) {
    }

    protected void scaleXChanged() {
        this.scaled_sourceX = this.getScaledX(this.sourceX);
        this.scaled_destX = this.getScaledX(this.destX);
        this.scaled_destWidth = this.getScaledX(this.destWidth);
    }

    protected void scaleYChanged() {
        this.scaled_sourceY = this.getScaledY(this.sourceY);
        this.scaled_destY = this.getScaledY(this.destY);
        this.scaled_destHeight = this.getScaledY(this.destHeight);
    }

    public void setDestination(int n, int n2, int n3, int n4) {
        this.destX = n;
        this.destY = n2;
        this.destWidth = n3;
        this.destHeight = n4;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public void setOperation(int n) {
        this.operation = n;
    }

    public void setOrigin(int n, int n2) {
        this.sourceX = n;
        this.sourceY = n2;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getLongParam(0);
        int n2 = mfRecord.getParam(2);
        int n3 = mfRecord.getParam(3);
        this.setOperation(n);
        this.setOrigin(n3, n2);
        if (mfRecord.getLength() == MfRecord.RECORD_HEADER_SIZE + 16) {
            int n4 = mfRecord.getParam(5);
            int n5 = mfRecord.getParam(6);
            int n6 = mfRecord.getParam(7);
            int n7 = mfRecord.getParam(8);
            this.setDestination(n7, n6, n5, n4);
        } else {
            int n8 = mfRecord.getParam(4);
            int n9 = mfRecord.getParam(5);
            int n10 = mfRecord.getParam(6);
            int n11 = mfRecord.getParam(7);
            this.setDestination(n11, n10, n9, n8);
            try {
                DIBReader dIBReader = new DIBReader();
                this.setImage(dIBReader.setRecord(mfRecord, 8));
            }
            catch (IOException iOException) {}
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[BIT_BLT] records=");
        stringBuffer.append(this.getOperation());
        stringBuffer.append(" source=");
        stringBuffer.append(this.getOrigin());
        stringBuffer.append(" destination=");
        stringBuffer.append(this.getDestination());
        return stringBuffer.toString();
    }
}

