/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.bitmap.DIBReader;
import org.jfree.pixie.wmf.records.MfCmd;
import org.jfree.pixie.wmf.records.RecordCreationException;

public class MfCmdDibStretchBlt
extends MfCmd {
    private static final int POS_DIB = 10;
    private static final int POS_OPERATION = 0;
    private static final int POS_SRC_HEIGHT = 2;
    private static final int POS_SRC_WIDTH = 3;
    private static final int POS_SRC_Y = 4;
    private static final int POS_SRC_X = 5;
    private static final int POS_DST_HEIGHT = 6;
    private static final int POS_DST_WIDTH = 7;
    private static final int POS_DST_Y = 8;
    private static final int POS_DST_X = 9;
    private BufferedImage image;
    private int rop;
    private int srcX;
    private int srcY;
    private int srcW;
    private int srcH;
    private int destX;
    private int destY;
    private int destW;
    private int destH;
    private int scaled_destX;
    private int scaled_destY;
    private int scaled_destW;
    private int scaled_destH;

    public Rectangle getDestRect() {
        return new Rectangle(this.destX, this.destY, this.destW, this.destH);
    }

    public int getFunction() {
        return 2881;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public MfCmd getInstance() {
        return new MfCmdDibStretchBlt();
    }

    public int getROP() {
        return this.rop;
    }

    public MfRecord getRecord() throws RecordCreationException {
        throw new RecordCreationException("StretchBlt is not supported");
    }

    public Rectangle getScaledDestRect() {
        return new Rectangle(this.scaled_destX, this.scaled_destY, this.scaled_destW, this.scaled_destH);
    }

    public Rectangle getSrcRect() {
        return new Rectangle(this.srcX, this.srcY, this.srcW, this.srcH);
    }

    public void replay(WmfFile wmfFile) {
        wmfFile.getGraphics2D().drawImage(this.image, this.srcX, this.srcY, this.srcW, this.srcH, this.scaled_destX, this.scaled_destY, this.scaled_destW, this.scaled_destH, null);
    }

    protected void scaleXChanged() {
        this.scaled_destX = this.getScaledX(this.destX);
        this.scaled_destW = this.getScaledX(this.destW);
    }

    protected void scaleYChanged() {
        this.scaled_destY = this.getScaledY(this.destY);
        this.scaled_destH = this.getScaledY(this.destH);
    }

    public void setDestRect(int n, int n2, int n3, int n4) {
        this.destX = n;
        this.destY = n2;
        this.destW = n3;
        this.destH = n4;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public void setROP(int n) {
        this.rop = n;
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getLongParam(0);
        int n2 = mfRecord.getParam(4);
        int n3 = mfRecord.getParam(5);
        int n4 = mfRecord.getParam(2);
        int n5 = mfRecord.getParam(3);
        int n6 = mfRecord.getParam(6);
        int n7 = mfRecord.getParam(7);
        int n8 = mfRecord.getParam(8);
        int n9 = mfRecord.getParam(9);
        try {
            DIBReader dIBReader = new DIBReader();
            this.setImage(dIBReader.setRecord(mfRecord, 10));
        }
        catch (IOException iOException) {}
        this.setROP(n);
        this.setSrcRect(n3, n2, n4, n5);
        this.setDestRect(n9, n8, n6, n7);
    }

    public void setSrcRect(int n, int n2, int n3, int n4) {
        this.srcX = n;
        this.srcY = n2;
        this.srcW = n3;
        this.srcH = n4;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[STRETCH_BLT] rop=");
        stringBuffer.append(this.getROP());
        stringBuffer.append(" srcRect=");
        stringBuffer.append(this.getSrcRect());
        stringBuffer.append(" destRect=");
        stringBuffer.append(this.getDestRect());
        return stringBuffer.toString();
    }
}

