/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Color;
import java.awt.Point;
import org.jfree.pixie.wmf.GDIColor;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;

public class MfCmdExtFloodFill
extends MfCmd {
    public static final int FLOODFILLBORDER = 0;
    public static final int FLOODFILLSURFACE = 1;
    private int filltype;
    private Color color;
    private int x;
    private int y;
    private int scaled_x;
    private int scaled_y;
    private static final int RECORD_SIZE = 5;
    private static final int POS_FILLTYPE = 0;
    private static final int POS_COLOR = 1;
    private static final int POS_Y = 3;
    private static final int POS_X = 4;

    public Color getColor() {
        return this.color;
    }

    public int getFillType() {
        return this.filltype;
    }

    public int getFunction() {
        return 1352;
    }

    public MfCmd getInstance() {
        return new MfCmdExtFloodFill();
    }

    public MfRecord getRecord() {
        MfRecord mfRecord = new MfRecord(5);
        mfRecord.setParam(0, this.getFillType());
        mfRecord.setLongParam(1, GDIColor.translateColor(this.getColor()));
        Point point = this.getTarget();
        mfRecord.setParam(3, (int)point.getY());
        mfRecord.setParam(4, (int)point.getX());
        return mfRecord;
    }

    public Point getScaledTarget() {
        return new Point(this.scaled_x, this.scaled_y);
    }

    public Point getTarget() {
        return new Point(this.x, this.y);
    }

    public void replay(WmfFile wmfFile) {
    }

    protected void scaleXChanged() {
        this.scaled_x = this.getScaledX(this.x);
    }

    protected void scaleYChanged() {
        this.scaled_y = this.getScaledY(this.y);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setFillType(int n) {
        this.filltype = n;
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(0);
        int n2 = mfRecord.getLongParam(1);
        GDIColor gDIColor = new GDIColor(n2);
        int n3 = mfRecord.getParam(3);
        int n4 = mfRecord.getParam(4);
        this.setTarget(n4, n3);
        this.setColor(gDIColor);
        this.setFillType(n);
    }

    public void setTarget(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[EXT_FLOOD_FILL] filltype=");
        stringBuffer.append(this.getFillType());
        stringBuffer.append(" color=");
        stringBuffer.append(this.getColor());
        stringBuffer.append(" target=");
        stringBuffer.append(this.getTarget());
        return stringBuffer.toString();
    }
}

