/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.jfree.pixie.wmf.MfDcState;
import org.jfree.pixie.wmf.MfLogFont;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;

public class MfCmdExtTextOut
extends MfCmd {
    private static final int POS_Y = 0;
    private static final int POS_X = 1;
    private static final int POS_CHAR_COUNT = 2;
    private static final int POS_FLAGS = 3;
    private static final int POS_CLIP_X = 4;
    private static final int POS_CLIP_Y = 5;
    private static final int POS_CLIP_W = 6;
    private static final int POS_CLIP_H = 7;
    private static final int RECORD_BASE_SIZE_CLIPPED = 8;
    private static final int RECORD_BASE_SIZE_STANDARD = 4;
    public static final int ETO_OPAQUE = 2;
    public static final int ETO_CLIPPED = 4;
    public static final int ETO_GLYPH_INDEX = 16;
    public static final int ETO_RTLREADING = 128;
    public static final int ETO_IGNORELANGUAGE = 4096;
    private int flags;
    private int x;
    private int y;
    private int cx;
    private int cy;
    private int cw;
    private int ch;
    private int scaled_x;
    private int scaled_y;
    private int scaled_cx;
    private int scaled_cy;
    private int scaled_cw;
    private int scaled_ch;
    private String text;

    protected int calcDeltaX(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        if (n == 6) {
            return n2 / -2;
        }
        return n2 * -1;
    }

    protected int calcDeltaY(int n, FontMetrics fontMetrics) {
        if (n == 0) {
            return fontMetrics.getAscent() * -1;
        }
        if (n == 8) {
            return fontMetrics.getDescent();
        }
        return 0;
    }

    public Rectangle getClippingRect() {
        return new Rectangle(this.cx, this.cy, this.cw, this.ch);
    }

    public int getFlags() {
        return this.flags;
    }

    public int getFunction() {
        return 2610;
    }

    public MfCmd getInstance() {
        return new MfCmdExtTextOut();
    }

    public Point getOrigin() {
        return new Point(this.x, this.y);
    }

    public MfRecord getRecord() {
        String string = this.getText();
        int n = this.getFlags();
        int n2 = (n & 4) == 4 ? 8 : 4;
        int n3 = (int)(Math.ceil(string.length() / 2) * 2.0) + n2;
        MfRecord mfRecord = new MfRecord(n3);
        Point point = this.getOrigin();
        mfRecord.setParam(0, (int)point.getY());
        mfRecord.setParam(1, (int)point.getX());
        mfRecord.setParam(2, string.length());
        mfRecord.setParam(3, n);
        if ((n & 4) == 4) {
            Rectangle rectangle = this.getClippingRect();
            mfRecord.setParam(4, rectangle.x);
            mfRecord.setParam(5, rectangle.y);
            mfRecord.setParam(6, rectangle.width);
            mfRecord.setParam(7, rectangle.height);
        }
        mfRecord.setStringParam(n2, string);
        return mfRecord;
    }

    public Rectangle getScaledClippingRect() {
        return new Rectangle(this.scaled_cx, this.scaled_cy, this.scaled_cw, this.scaled_ch);
    }

    public Point getScaledOrigin() {
        return new Point(this.scaled_x, this.scaled_y);
    }

    public String getText() {
        return this.text;
    }

    public boolean isClipped() {
        return (this.flags & 4) == 4;
    }

    public boolean isOpaque() {
        return (this.flags & 2) == 2;
    }

    public void replay(WmfFile wmfFile) {
        Graphics2D graphics2D = wmfFile.getGraphics2D();
        MfDcState mfDcState = wmfFile.getCurrentState();
        MfLogFont mfLogFont = mfDcState.getLogFont();
        mfDcState.prepareDrawText();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n = fontMetrics.stringWidth(this.text);
        Point point = this.getScaledOrigin();
        int n2 = point.x + this.calcDeltaX(mfDcState.getVerticalTextAlignment(), n);
        int n3 = point.y + this.calcDeltaY(mfDcState.getHorizontalTextAlignment(), fontMetrics);
        if (this.isOpaque() || mfDcState.getBkMode() != 1) {
            Rectangle rectangle = new Rectangle(n2, n3 - fontMetrics.getAscent(), n, fontMetrics.getHeight());
            graphics2D.setColor(mfDcState.getBkColor());
            graphics2D.fill(rectangle);
            graphics2D.setColor(mfDcState.getTextColor());
        }
        graphics2D.drawString(this.text, n2, n3);
        mfDcState.postDrawText();
        if (mfLogFont.isUnderline()) {
            mfDcState.prepareDraw();
            graphics2D.drawLine(n2, n3 += fontMetrics.getDescent() / 8 + 1, n2 + n, n3);
            mfDcState.postDraw();
        }
        if (mfLogFont.isStrikeOut()) {
            mfDcState.prepareDraw();
            graphics2D.drawLine(n2, n3 -= fontMetrics.getDescent() / 2 + 1, n2 + n, n3);
            mfDcState.postDraw();
        }
    }

    protected void scaleXChanged() {
        this.scaled_x = this.getScaledX(this.x);
        this.scaled_cx = this.getScaledX(this.cx);
        this.scaled_cw = this.getScaledX(this.cw);
    }

    protected void scaleYChanged() {
        this.scaled_y = this.getScaledY(this.y);
        this.scaled_cy = this.getScaledY(this.cy);
        this.scaled_ch = this.getScaledY(this.ch);
    }

    public void setClippingRect(int n, int n2, int n3, int n4) {
        this.cx = n;
        this.cy = n2;
        this.cw = n3;
        this.ch = n4;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public void setOrigin(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(0);
        int n2 = mfRecord.getParam(1);
        int n3 = mfRecord.getParam(2);
        int n4 = mfRecord.getParam(3);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if ((n4 & 4) == 4) {
            n6 = mfRecord.getParam(4);
            n7 = mfRecord.getParam(5);
            n8 = mfRecord.getParam(6);
            n9 = mfRecord.getParam(7);
            n5 = 8;
        } else {
            n5 = 4;
        }
        String string = mfRecord.getStringParam(n5, n3);
        this.setOrigin(n2, n);
        this.setText(string);
        this.setClippingRect(n6, n7, n8, n9);
        this.setFlags(n4);
    }

    public void setText(String string) {
        this.text = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[EXT_TEXT_OUT] text=");
        stringBuffer.append(this.getText());
        stringBuffer.append(" origin=");
        stringBuffer.append(this.getOrigin());
        stringBuffer.append(" clippingRect=");
        stringBuffer.append(this.getClippingRect());
        stringBuffer.append(" flags=");
        stringBuffer.append(this.getFlags());
        return stringBuffer.toString();
    }
}

