/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.jfree.pixie.wmf.MfDcState;
import org.jfree.pixie.wmf.MfLogBrush;
import org.jfree.pixie.wmf.MfLogRegion;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;

public class MfCmdFillRegion
extends MfCmd {
    private static final int RECORD_SIZE = 2;
    private static final int POS_REGION = 0;
    private static final int POS_BRUSH = 1;
    private int brushObjectNr;
    private int regionObjectNr;

    public int getBrush() {
        return this.brushObjectNr;
    }

    public int getFunction() {
        return 552;
    }

    public MfCmd getInstance() {
        return new MfCmdFillRegion();
    }

    public MfRecord getRecord() {
        MfRecord mfRecord = new MfRecord(2);
        mfRecord.setParam(0, this.getRegion());
        mfRecord.setParam(1, this.getBrush());
        return mfRecord;
    }

    public int getRegion() {
        return this.regionObjectNr;
    }

    public void replay(WmfFile wmfFile) {
        MfLogBrush mfLogBrush = wmfFile.getBrushObject(this.brushObjectNr);
        MfLogRegion mfLogRegion = wmfFile.getRegionObject(this.regionObjectNr);
        MfDcState mfDcState = wmfFile.getCurrentState();
        mfDcState.setLogRegion(mfLogRegion);
        mfDcState.setLogBrush(mfLogBrush);
        Graphics2D graphics2D = wmfFile.getGraphics2D();
        Rectangle rectangle = this.scaleRect(mfLogRegion.getBounds());
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        double_.setFrame(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (mfLogBrush.isVisible()) {
            mfDcState.preparePaint();
            graphics2D.fill(double_);
            mfDcState.postPaint();
        }
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }

    public void setBrush(int n) {
        this.brushObjectNr = n;
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(0);
        int n2 = mfRecord.getParam(1);
        this.setBrush(n2);
        this.setRegion(n);
    }

    public void setRegion(int n) {
        this.regionObjectNr = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[FILL_REGION] brush=");
        stringBuffer.append(this.getBrush());
        stringBuffer.append(" region=");
        stringBuffer.append(this.getRegion());
        return stringBuffer.toString();
    }
}

