/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.jfree.pixie.wmf.MfDcState;
import org.jfree.pixie.wmf.MfLogBrush;
import org.jfree.pixie.wmf.MfLogRegion;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;

public class MfCmdFrameRegion
extends MfCmd {
    private int width;
    private int height;
    private int scaled_width;
    private int scaled_height;
    private int brushObjectNr;
    private int regionObjectNr;

    public int getBrush() {
        return this.brushObjectNr;
    }

    public Dimension getDimension() {
        return new Dimension(this.width, this.height);
    }

    public int getFunction() {
        return 1065;
    }

    public MfCmd getInstance() {
        return new MfCmdFrameRegion();
    }

    public MfRecord getRecord() {
        MfRecord mfRecord = new MfRecord(4);
        Dimension dimension = this.getDimension();
        mfRecord.setParam(0, dimension.height);
        mfRecord.setParam(1, dimension.width);
        mfRecord.setParam(2, this.getRegion());
        mfRecord.setParam(3, this.getBrush());
        return mfRecord;
    }

    public int getRegion() {
        return this.regionObjectNr;
    }

    public Dimension getScaledDimension() {
        return new Dimension(this.scaled_width, this.scaled_height);
    }

    public void replay(WmfFile wmfFile) {
        MfLogBrush mfLogBrush = wmfFile.getBrushObject(this.brushObjectNr);
        MfLogRegion mfLogRegion = wmfFile.getRegionObject(this.regionObjectNr);
        MfDcState mfDcState = wmfFile.getCurrentState();
        mfDcState.setLogRegion(mfLogRegion);
        mfDcState.setLogBrush(mfLogBrush);
        Graphics2D graphics2D = wmfFile.getGraphics2D();
        Rectangle rectangle = this.scaleRect(mfLogRegion.getBounds());
        if (mfLogBrush.isVisible()) {
            Dimension dimension = this.getScaledDimension();
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            double_.setFrame(rectangle.x, rectangle.y, rectangle.width, dimension.height);
            mfDcState.preparePaint();
            graphics2D.fill(double_);
            double_.setFrame(rectangle.x, rectangle.y - dimension.height, rectangle.width, dimension.height);
            graphics2D.fill(double_);
            double_.setFrame(rectangle.x, rectangle.y, dimension.width, rectangle.height);
            graphics2D.fill(double_);
            double_.setFrame(rectangle.width - dimension.width, rectangle.y, dimension.width, rectangle.height);
            graphics2D.fill(double_);
            mfDcState.postPaint();
        }
    }

    protected void scaleXChanged() {
        this.scaled_width = this.getScaledX(this.width);
    }

    protected void scaleYChanged() {
        this.scaled_height = this.getScaledY(this.height);
    }

    public void setBrush(int n) {
        this.brushObjectNr = n;
    }

    public void setDimension(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setDimension(Dimension dimension) {
        this.setDimension(dimension.width, dimension.height);
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(0);
        int n2 = mfRecord.getParam(1);
        int n3 = mfRecord.getParam(2);
        int n4 = mfRecord.getParam(3);
        this.setBrush(n4);
        this.setRegion(n3);
        this.setDimension(n2, n);
    }

    public void setRegion(int n) {
        this.regionObjectNr = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[FRAME_REGION] region=");
        stringBuffer.append(this.getRegion());
        stringBuffer.append(" brush=");
        stringBuffer.append(this.getBrush());
        stringBuffer.append(" dimension=");
        stringBuffer.append(this.getDimension());
        return stringBuffer.toString();
    }
}

