/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.jfree.pixie.wmf.MfDcState;
import org.jfree.pixie.wmf.MfLogBrush;
import org.jfree.pixie.wmf.MfLogRegion;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;

public class MfCmdPaintRgn
extends MfCmd {
    private static final int RECORD_SIZE = 1;
    private static final int POS_REGION = 0;
    private int region;

    public int getFunction() {
        return 299;
    }

    public MfCmd getInstance() {
        return new MfCmdPaintRgn();
    }

    public MfRecord getRecord() {
        MfRecord mfRecord = new MfRecord(1);
        mfRecord.setParam(0, this.getRegion());
        return mfRecord;
    }

    public int getRegion() {
        return this.region;
    }

    public void replay(WmfFile wmfFile) {
        MfLogRegion mfLogRegion = wmfFile.getRegionObject(this.region);
        MfDcState mfDcState = wmfFile.getCurrentState();
        mfDcState.setLogRegion(mfLogRegion);
        MfLogBrush mfLogBrush = mfDcState.getLogBrush();
        Graphics2D graphics2D = wmfFile.getGraphics2D();
        Rectangle rectangle = this.scaleRect(mfLogRegion.getBounds());
        if (mfLogBrush.isVisible()) {
            mfDcState.preparePaint();
            graphics2D.fill(rectangle);
            mfDcState.postPaint();
        }
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }

    public void setRecord(MfRecord mfRecord) {
        this.region = mfRecord.getParam(0);
    }

    public void setRegion(int n) {
        this.region = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[PAINT_REGION] region=");
        stringBuffer.append(this.getRegion());
        return stringBuffer.toString();
    }
}

