/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.jfree.pixie.wmf.MfDcState;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;

public class MfCmdPatBlt
extends MfCmd {
    private static final int RECORD_SIZE = 6;
    private static final int POS_ROP = 0;
    private static final int POS_HEIGHT = 2;
    private static final int POS_WIDTH = 3;
    private static final int POS_Y = 4;
    private static final int POS_X = 5;
    private int rop;
    private int height;
    private int width;
    private int x;
    private int y;
    private int scaled_x;
    private int scaled_y;
    private int scaled_width;
    private int scaled_height;

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public int getFunction() {
        return 1565;
    }

    public MfCmd getInstance() {
        return new MfCmdPatBlt();
    }

    public int getROP() {
        return this.rop;
    }

    public MfRecord getRecord() {
        MfRecord mfRecord = new MfRecord(6);
        mfRecord.setParam(0, this.getROP());
        Rectangle rectangle = this.getBounds();
        mfRecord.setParam(2, rectangle.height);
        mfRecord.setParam(3, rectangle.width);
        mfRecord.setParam(4, rectangle.y);
        mfRecord.setParam(5, rectangle.x);
        return mfRecord;
    }

    public Rectangle getScaledBounds() {
        return new Rectangle(this.scaled_x, this.scaled_y, this.scaled_width, this.scaled_height);
    }

    public void replay(WmfFile wmfFile) {
        switch (this.rop) {
            case 15728673: {
                MfDcState mfDcState = wmfFile.getCurrentState();
                mfDcState.preparePaint();
                Graphics2D graphics2D = (Graphics2D)wmfFile.getGraphics2D().create();
                graphics2D.setPaintMode();
                graphics2D.fill(this.getScaledBounds());
                mfDcState.postPaint();
                break;
            }
            case 5898313: {
                MfDcState mfDcState = wmfFile.getCurrentState();
                mfDcState.preparePaint();
                Graphics2D graphics2D = (Graphics2D)wmfFile.getGraphics2D().create();
                graphics2D.setXORMode(graphics2D.getColor());
                graphics2D.fill(this.getScaledBounds());
                mfDcState.postPaint();
                break;
            }
            case 0x550009: {
                Graphics2D graphics2D = (Graphics2D)wmfFile.getGraphics2D().create();
                graphics2D.setXORMode(Color.white);
                graphics2D.fill(this.getScaledBounds());
                break;
            }
        }
    }

    protected void scaleXChanged() {
        this.scaled_x = this.getScaledX(this.x);
        this.scaled_width = this.getScaledX(this.width);
    }

    protected void scaleYChanged() {
        this.scaled_y = this.getScaledY(this.y);
        this.scaled_height = this.getScaledY(this.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setROP(int n) {
        this.rop = n;
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getLongParam(0);
        int n2 = mfRecord.getParam(2);
        int n3 = mfRecord.getParam(3);
        int n4 = mfRecord.getParam(5);
        int n5 = mfRecord.getParam(4);
        this.setBounds(n5, n4, n3, n2);
        this.setROP(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[PAT_BLT] rop=");
        stringBuffer.append(this.getROP());
        stringBuffer.append(" bounds=");
        stringBuffer.append(this.getBounds());
        return stringBuffer.toString();
    }
}

