/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Graphics2D;
import java.awt.Polygon;
import org.jfree.pixie.wmf.MfDcState;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;
import org.jfree.pixie.wmf.records.RecordCreationException;

public class MfCmdPolyPolygon
extends MfCmd {
    private Object[] points_x;
    private Object[] points_y;
    private Object[] scaled_points_x;
    private Object[] scaled_points_y;
    private int polycount;

    public int getFunction() {
        return 1336;
    }

    public MfCmd getInstance() {
        return new MfCmdPolyPolygon();
    }

    public int[] getPointsX(int n) {
        return (int[])this.points_x[n];
    }

    public int[] getPointsY(int n) {
        return (int[])this.points_y[n];
    }

    public int getPolygonCount() {
        return this.polycount;
    }

    public MfRecord getRecord() throws RecordCreationException {
        int n = this.getPolygonCount();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += this.getPointsX(n3).length;
            ++n3;
        }
        MfRecord mfRecord = new MfRecord(1 + n + n2 * 2);
        mfRecord.setParam(0, n);
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            int[] nArray = this.getPointsX(n5);
            int[] nArray2 = this.getPointsY(n5);
            int n6 = nArray.length;
            mfRecord.setParam(1 + n5, n6);
            int n7 = n4 * 2 + n + 1;
            int n8 = 0;
            while (n8 < n6) {
                mfRecord.setParam(n7 + 1 + n8 * 2, nArray[n5]);
                mfRecord.setParam(n7 + 2 + n8 * 2, nArray2[n5]);
                ++n8;
            }
            n4 += n6;
            ++n5;
        }
        return mfRecord;
    }

    public int[] getScaledPointsX(int n) {
        return (int[])this.scaled_points_x[n];
    }

    public int[] getScaledPointsY(int n) {
        return (int[])this.scaled_points_y[n];
    }

    public void replay(WmfFile wmfFile) {
        Graphics2D graphics2D = wmfFile.getGraphics2D();
        MfDcState mfDcState = wmfFile.getCurrentState();
        int n = 0;
        while (n < this.polycount) {
            int[] nArray = this.getScaledPointsX(n);
            int[] nArray2 = this.getScaledPointsY(n);
            Polygon polygon = new Polygon(nArray, nArray2, nArray.length);
            if (mfDcState.getLogBrush().isVisible()) {
                mfDcState.preparePaint();
                graphics2D.fill(polygon);
                mfDcState.postPaint();
            }
            if (mfDcState.getLogPen().isVisible()) {
                mfDcState.prepareDraw();
                graphics2D.draw(polygon);
                mfDcState.postDraw();
            }
            ++n;
        }
    }

    protected void scaleXChanged() {
        if (this.scaled_points_x == null) {
            this.scaled_points_x = new Object[this.points_x.length];
        }
        if (this.scaled_points_x.length < this.points_x.length) {
            this.scaled_points_x = new Object[this.points_x.length];
        }
        int n = 0;
        while (n < this.polycount) {
            this.scaled_points_x[n] = this.applyScaleX((int[])this.points_x[n], (int[])this.scaled_points_x[n]);
            ++n;
        }
    }

    protected void scaleYChanged() {
        if (this.scaled_points_y == null) {
            this.scaled_points_y = new Object[this.points_y.length];
        }
        if (this.scaled_points_y.length < this.points_y.length) {
            this.scaled_points_y = new Object[this.points_y.length];
        }
        int n = 0;
        while (n < this.polycount) {
            this.scaled_points_y[n] = this.applyScaleY((int[])this.points_y[n], (int[])this.scaled_points_y[n]);
            ++n;
        }
    }

    public void setPoints(Object[] objectArray, Object[] objectArray2) {
        this.points_x = objectArray;
        this.points_y = objectArray2;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setPolygonCount(int n) {
        this.polycount = n;
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(0);
        int[] nArray = new int[n];
        Object[] objectArray = new Object[n];
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            nArray[n3] = n4 = mfRecord.getParam(1 + n3);
            int[] nArray2 = new int[n4];
            int[] nArray3 = new int[n4];
            int n5 = n2 * 2 + n + 1;
            int n6 = 0;
            while (n6 < n4) {
                nArray2[n6] = mfRecord.getParam(n5 + 1 + n6 * 2);
                nArray3[n6] = mfRecord.getParam(n5 + 2 + n6 * 2);
                ++n6;
            }
            objectArray[n3] = nArray2;
            objectArray2[n3] = nArray3;
            n2 += n4;
            ++n3;
        }
        this.setPolygonCount(n);
        this.setPoints(objectArray, objectArray2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[POLYPOLYGON] polycount=");
        stringBuffer.append(this.getPolygonCount());
        stringBuffer.append("\n");
        int n = 0;
        while (n < this.getPolygonCount()) {
            stringBuffer.append("  Polygon ");
            stringBuffer.append(n);
            int[] nArray = this.getPointsX(n);
            int[] nArray2 = this.getPointsY(n);
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n2) {
                if (n3 != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(" (");
                stringBuffer.append(nArray[n3]);
                stringBuffer.append(",");
                stringBuffer.append(nArray2[n3]);
                stringBuffer.append(") ");
                ++n3;
            }
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }
}

