/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Graphics2D;
import java.awt.Polygon;
import org.jfree.pixie.wmf.MfDcState;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;
import org.jfree.pixie.wmf.records.RecordCreationException;

public class MfCmdPolygon
extends MfCmd {
    private int[] points_x;
    private int[] points_y;
    private int[] scaled_points_x;
    private int[] scaled_points_y;
    private int count;

    public int getFunction() {
        return 804;
    }

    public MfCmd getInstance() {
        return new MfCmdPolygon();
    }

    public int getPointCount() {
        return this.count;
    }

    public int[] getPointsX() {
        return this.points_x;
    }

    public int[] getPointsY() {
        return this.points_y;
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord mfRecord = new MfRecord(this.getPointCount() * 2 + 1);
        int n = this.getPointCount();
        int[] nArray = this.getPointsX();
        int[] nArray2 = this.getPointsY();
        mfRecord.setParam(0, n);
        int n2 = 0;
        while (n2 < n) {
            mfRecord.setParam(1 + 2 * n2, nArray[n2]);
            mfRecord.setParam(2 + 2 * n2, nArray2[n2]);
            ++n2;
        }
        return mfRecord;
    }

    public int[] getScaledPointsX() {
        return this.scaled_points_x;
    }

    public int[] getScaledPointsY() {
        return this.scaled_points_y;
    }

    public void replay(WmfFile wmfFile) {
        Graphics2D graphics2D = wmfFile.getGraphics2D();
        Polygon polygon = new Polygon(this.getScaledPointsX(), this.getScaledPointsY(), this.getPointCount());
        MfDcState mfDcState = wmfFile.getCurrentState();
        if (mfDcState.getLogBrush().isVisible()) {
            mfDcState.preparePaint();
            graphics2D.fill(polygon);
            mfDcState.postPaint();
        }
        if (mfDcState.getLogPen().isVisible()) {
            mfDcState.prepareDraw();
            graphics2D.draw(polygon);
            mfDcState.postDraw();
        }
    }

    protected void scaleXChanged() {
        this.scaled_points_x = this.applyScaleX(this.points_x, this.scaled_points_x);
    }

    protected void scaleYChanged() {
        this.scaled_points_y = this.applyScaleY(this.points_y, this.scaled_points_y);
    }

    public void setPointCount(int n) {
        this.count = n;
    }

    public void setPoints(int[] nArray, int[] nArray2) {
        this.points_x = nArray;
        this.points_y = nArray2;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(0);
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = mfRecord.getParam(1 + 2 * n2);
            nArray2[n2] = mfRecord.getParam(2 + 2 * n2);
            ++n2;
        }
        this.setPointCount(n);
        this.setPoints(nArray, nArray2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[POLYGON] count=");
        stringBuffer.append(this.getPointCount());
        int n = this.getPointCount();
        int[] nArray = this.getPointsX();
        int[] nArray2 = this.getPointsY();
        int n2 = 0;
        while (n2 < n) {
            if (n2 != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(" (");
            stringBuffer.append(nArray[n2]);
            stringBuffer.append(",");
            stringBuffer.append(nArray2[n2]);
            stringBuffer.append(") ");
            ++n2;
        }
        return stringBuffer.toString();
    }
}

