/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import org.jfree.pixie.wmf.MfLogBrush;
import org.jfree.pixie.wmf.MfLogFont;
import org.jfree.pixie.wmf.MfLogPalette;
import org.jfree.pixie.wmf.MfLogPen;
import org.jfree.pixie.wmf.MfLogRegion;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.WmfObject;
import org.jfree.pixie.wmf.records.MfCmd;
import org.jfree.pixie.wmf.records.RecordCreationException;

public class MfCmdSelectObject
extends MfCmd {
    private static final int RECORD_SIZE = 1;
    private static final int POS_OBJECT_ID = 0;
    private int objectId;

    public int getFunction() {
        return 301;
    }

    public MfCmd getInstance() {
        return new MfCmdSelectObject();
    }

    public int getObjectId() {
        return this.objectId;
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord mfRecord = new MfRecord(1);
        mfRecord.setParam(0, this.getObjectId());
        return mfRecord;
    }

    public void replay(WmfFile wmfFile) {
        WmfObject wmfObject = wmfFile.getObject(this.objectId);
        if (wmfObject == null) {
            throw new NullPointerException("Object " + this.objectId + " is not defined");
        }
        switch (wmfObject.getType()) {
            case 2: {
                wmfFile.getCurrentState().setLogBrush((MfLogBrush)wmfObject);
                break;
            }
            case 4: {
                wmfFile.getCurrentState().setLogFont((MfLogFont)wmfObject);
                break;
            }
            case 3: {
                wmfFile.getCurrentState().setLogPalette((MfLogPalette)wmfObject);
                break;
            }
            case 1: {
                wmfFile.getCurrentState().setLogPen((MfLogPen)wmfObject);
                break;
            }
            case 5: {
                wmfFile.getCurrentState().setLogRegion((MfLogRegion)wmfObject);
                break;
            }
        }
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }

    public void setObjectId(int n) {
        this.objectId = n;
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(0);
        this.setObjectId(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SELECT_OBJECT] object=");
        stringBuffer.append(this.getObjectId());
        return stringBuffer.toString();
    }
}

