/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import org.jfree.pixie.wmf.MfLogPalette;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.WmfObject;
import org.jfree.pixie.wmf.records.MfCmd;
import org.jfree.pixie.wmf.records.RecordCreationException;

public class MfCmdSelectPalette
extends MfCmd {
    private static final int RECORD_SIZE = 1;
    private static final int POS_OBJECT_ID = 0;
    private int objectId;

    public int getFunction() {
        return 564;
    }

    public MfCmd getInstance() {
        return new MfCmdSelectPalette();
    }

    public int getObjectId() {
        return this.objectId;
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord mfRecord = new MfRecord(1);
        mfRecord.setParam(0, this.getObjectId());
        return mfRecord;
    }

    public void replay(WmfFile wmfFile) {
        WmfObject wmfObject = wmfFile.getObject(this.objectId);
        if (wmfObject == null) {
            throw new NullPointerException();
        }
        switch (wmfObject.getType()) {
            case 3: {
                wmfFile.getCurrentState().setLogPalette((MfLogPalette)wmfObject);
                break;
            }
            default: {
                throw new IllegalStateException("Object is no palette");
            }
        }
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }

    public void setObjectId(int n) {
        this.objectId = n;
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(0);
        this.setObjectId(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SELECT_PALETTE] object=");
        stringBuffer.append(this.getObjectId());
        return stringBuffer.toString();
    }
}

