/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Color;
import org.jfree.pixie.wmf.GDIColor;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;
import org.jfree.pixie.wmf.records.RecordCreationException;

public class MfCmdSetPaletteEntries
extends MfCmd {
    private int BASE_RECORD_SIZE = 3;
    private int POS_H_PALETTE = 0;
    private int POS_CSTART = 1;
    private int POS_CENTRIES = 2;
    private int hPalette;
    private Color[] colors;
    private int startPos;

    public Color[] getEntries() {
        return this.colors;
    }

    public int getFunction() {
        return 55;
    }

    public int getHPalette() {
        return this.hPalette;
    }

    public MfCmd getInstance() {
        return new MfCmdSetPaletteEntries();
    }

    public MfRecord getRecord() throws RecordCreationException {
        Color[] colorArray = this.getEntries();
        if (colorArray == null) {
            throw new NullPointerException("No CEntries set");
        }
        MfRecord mfRecord = new MfRecord(2 * colorArray.length + this.BASE_RECORD_SIZE);
        mfRecord.setParam(this.POS_H_PALETTE, this.getHPalette());
        mfRecord.setParam(this.POS_CSTART, this.getStartPos());
        mfRecord.setParam(this.POS_CENTRIES, colorArray.length);
        int n = 0;
        while (n < colorArray.length) {
            mfRecord.setLongParam(2 * n + this.BASE_RECORD_SIZE, GDIColor.translateColor(colorArray[n]));
            ++n;
        }
        return mfRecord;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public void replay(WmfFile wmfFile) {
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }

    public void setEntries(Color[] colorArray) {
        this.colors = colorArray;
    }

    public void setHPalette(int n) {
        this.hPalette = n;
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(this.POS_H_PALETTE);
        int n2 = mfRecord.getParam(this.POS_CSTART);
        int n3 = mfRecord.getParam(this.POS_CENTRIES);
        Color[] colorArray = new Color[n3];
        int n4 = 0;
        while (n4 < n3) {
            int n5 = mfRecord.getLongParam(2 * n4 + this.BASE_RECORD_SIZE);
            GDIColor gDIColor = new GDIColor(n5);
            colorArray[n4] = gDIColor;
            ++n4;
        }
        this.setStartPos(n2);
        this.setEntries(colorArray);
        this.setHPalette(n);
    }

    public void setStartPos(int n) {
        this.startPos = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SET_PALETTE_ENTRIES] entriesCount=");
        if (this.getEntries() == null) {
            stringBuffer.append(0);
        } else {
            stringBuffer.append(this.getEntries().length);
        }
        stringBuffer.append(" hpalette=");
        stringBuffer.append(this.hPalette);
        return stringBuffer.toString();
    }
}

