/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import org.jfree.pixie.wmf.GDIColor;
import org.jfree.pixie.wmf.MfDcState;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;
import org.jfree.pixie.wmf.records.RecordCreationException;

public class MfCmdSetPixel
extends MfCmd {
    private static final int RECORD_SIZE = 4;
    private static final int POS_COLOR = 0;
    private static final int POS_X = 3;
    private static final int POS_Y = 2;
    private int x;
    private int y;
    private int scaled_x;
    private int scaled_y;
    private Color color;

    public Color getColor() {
        return this.color;
    }

    public int getFunction() {
        return 1055;
    }

    public MfCmd getInstance() {
        return new MfCmdSetPixel();
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord mfRecord = new MfRecord(4);
        mfRecord.setLongParam(0, GDIColor.translateColor(this.getColor()));
        Point point = this.getTarget();
        mfRecord.setParam(3, point.x);
        mfRecord.setParam(2, point.y);
        return mfRecord;
    }

    public Point getScaledTarget() {
        return new Point(this.scaled_x, this.scaled_y);
    }

    public Point getTarget() {
        return new Point(this.x, this.y);
    }

    public void replay(WmfFile wmfFile) {
        Point point = this.getScaledTarget();
        Graphics2D graphics2D = wmfFile.getGraphics2D();
        MfDcState mfDcState = wmfFile.getCurrentState();
        mfDcState.prepareDraw();
        graphics2D.drawLine(point.x, point.y, point.x, point.y);
        mfDcState.postDraw();
    }

    protected void scaleXChanged() {
        this.scaled_x = this.getScaledX(this.x);
    }

    protected void scaleYChanged() {
        this.scaled_y = this.getScaledY(this.y);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getLongParam(0);
        GDIColor gDIColor = new GDIColor(n);
        int n2 = mfRecord.getParam(2);
        int n3 = mfRecord.getParam(3);
        this.setTarget(n3, n2);
        this.setColor(gDIColor);
    }

    public void setTarget(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setTarget(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SET_PIXEL] target=");
        stringBuffer.append(this.getTarget());
        stringBuffer.append(" color=");
        stringBuffer.append(this.getColor());
        return stringBuffer.toString();
    }
}

