/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Color;
import org.jfree.pixie.wmf.GDIColor;
import org.jfree.pixie.wmf.MfDcState;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;
import org.jfree.pixie.wmf.records.RecordCreationException;

public class MfCmdSetTextColor
extends MfCmd {
    private static final int RECORD_SIZE = 2;
    private static final int POS_COLOR = 0;
    private Color color;

    public Color getColor() {
        return this.color;
    }

    public int getFunction() {
        return 521;
    }

    public MfCmd getInstance() {
        return new MfCmdSetTextColor();
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord mfRecord = new MfRecord(2);
        mfRecord.setLongParam(0, GDIColor.translateColor(this.getColor()));
        return mfRecord;
    }

    public void replay(WmfFile wmfFile) {
        MfDcState mfDcState = wmfFile.getCurrentState();
        mfDcState.setTextColor(this.color);
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getLongParam(0);
        this.setColor(new GDIColor(n));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SET_TEXT_COLOR] textColor=");
        stringBuffer.append(this.getColor());
        return stringBuffer.toString();
    }
}

