/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import org.jfree.pixie.wmf.MfDcState;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;
import org.jfree.pixie.wmf.records.RecordCreationException;

public class MfCmdSetTextJustification
extends MfCmd {
    private static final int RECORD_SIZE = 2;
    private static final int POS_SPACELENGTH = 0;
    private static final int POS_BREAKCOUNT = 1;
    private int extraSpaceLength;
    private int breakCount;

    public int getBreakCount() {
        return this.breakCount;
    }

    public int getExtraSpaceLength() {
        return this.extraSpaceLength;
    }

    public int getFunction() {
        return 522;
    }

    public MfCmd getInstance() {
        return new MfCmdSetTextJustification();
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord mfRecord = new MfRecord(2);
        mfRecord.setParam(1, this.getBreakCount());
        mfRecord.setParam(0, this.getExtraSpaceLength());
        return mfRecord;
    }

    public void replay(WmfFile wmfFile) {
        MfDcState mfDcState = wmfFile.getCurrentState();
        mfDcState.setTextJustification(this.extraSpaceLength, this.breakCount);
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }

    public void setBreakCount(int n) {
        this.breakCount = n;
    }

    public void setExtraSpaceLength(int n) {
        this.extraSpaceLength = n;
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(0);
        int n2 = mfRecord.getParam(1);
        this.setExtraSpaceLength(n);
        this.setBreakCount(n2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SET_TEXT_JUSTIFICATION] breakCount=");
        stringBuffer.append(this.getBreakCount());
        stringBuffer.append(" extraSpaceLength=");
        stringBuffer.append(this.getExtraSpaceLength());
        return stringBuffer.toString();
    }
}

