/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Dimension;
import org.jfree.pixie.wmf.MfDcState;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;
import org.jfree.pixie.wmf.records.RecordCreationException;

public class MfCmdSetViewPortExt
extends MfCmd {
    private static final int RECORD_SIZE = 2;
    private static final int POS_HEIGHT = 0;
    private static final int POS_WIDTH = 1;
    private int height;
    private int width;
    private int scaled_width;
    private int scaled_height;

    public Dimension getDimension() {
        return new Dimension(this.width, this.height);
    }

    public int getFunction() {
        return 526;
    }

    public MfCmd getInstance() {
        return new MfCmdSetViewPortExt();
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord mfRecord = new MfRecord(2);
        Dimension dimension = this.getDimension();
        mfRecord.setParam(0, dimension.height);
        mfRecord.setParam(1, dimension.width);
        return mfRecord;
    }

    public Dimension getScaledDimension() {
        return new Dimension(this.scaled_width, this.scaled_height);
    }

    public void replay(WmfFile wmfFile) {
        MfDcState mfDcState = wmfFile.getCurrentState();
        Dimension dimension = this.getScaledDimension();
        mfDcState.setViewportExt(dimension.width, dimension.height);
    }

    protected void scaleXChanged() {
        this.scaled_width = this.getScaledX(this.width);
    }

    protected void scaleYChanged() {
        this.scaled_height = this.getScaledY(this.height);
    }

    public void setDimension(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(0);
        int n2 = mfRecord.getParam(1);
        this.setDimension(n2, n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SET_VIEWPORT_EXT] dimension=");
        stringBuffer.append(this.getDimension());
        return stringBuffer.toString();
    }
}

