/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pixie.wmf.records;

import java.awt.Point;
import org.jfree.pixie.wmf.MfDcState;
import org.jfree.pixie.wmf.MfRecord;
import org.jfree.pixie.wmf.WmfFile;
import org.jfree.pixie.wmf.records.MfCmd;
import org.jfree.pixie.wmf.records.RecordCreationException;

public class MfCmdSetWindowOrg
extends MfCmd {
    private static final int RECORD_SIZE = 2;
    private static final int POS_Y = 0;
    private static final int POS_X = 1;
    private int x;
    private int y;
    private int scaled_x;
    private int scaled_y;

    public int getFunction() {
        return 523;
    }

    public MfCmd getInstance() {
        return new MfCmdSetWindowOrg();
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord mfRecord = new MfRecord(2);
        Point point = this.getTarget();
        mfRecord.setParam(1, point.x);
        mfRecord.setParam(0, point.y);
        return mfRecord;
    }

    public Point getScaledTarget() {
        return new Point(this.scaled_x, this.scaled_y);
    }

    public Point getTarget() {
        return new Point(this.x, this.y);
    }

    public void replay(WmfFile wmfFile) {
        MfDcState mfDcState = wmfFile.getCurrentState();
        Point point = this.getScaledTarget();
        mfDcState.setWindowOrg(point.x, point.y);
    }

    protected void scaleXChanged() {
        this.scaled_x = this.getScaledX(this.x);
    }

    protected void scaleYChanged() {
        this.scaled_y = this.getScaledY(this.y);
    }

    public void setRecord(MfRecord mfRecord) {
        int n = mfRecord.getParam(0);
        int n2 = mfRecord.getParam(1);
        this.setTarget(n2, n);
    }

    public void setTarget(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SET_WINDOW_ORG] target=");
        stringBuffer.append(this.getTarget());
        return stringBuffer.toString();
    }
}

