/*
 * Decompiled with CFR 0.152.
 */
package q.storage.columnar;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import q.datasource.io.AbstractInputStream;
import q.storage.columnar.api.b;
import q.storage.columnar.api.c;
import q.storage.columnar.h;
import q.storage.columnar.metadata.FileMetaData;
import q.storage.columnar.metadata.a.a;
import q.storage.columnar.metadata.f;
import q.storage.columnar.u;
import shaded.org.apache.parquet.CorruptDeltaByteArrays;
import shaded.org.apache.parquet.Log;
import shaded.org.apache.parquet.Preconditions;
import shaded.org.apache.parquet.column.Encoding;
import shaded.org.apache.parquet.column.page.PageReadStore;
import shaded.org.apache.parquet.filter.UnboundRecordFilter;
import shaded.org.apache.parquet.filter2.compat.FilterCompat;
import shaded.org.apache.parquet.io.ColumnIOFactory;
import shaded.org.apache.parquet.io.MessageColumnIO;
import shaded.org.apache.parquet.io.ParquetDecodingException;
import shaded.org.apache.parquet.io.RecordReader;
import shaded.org.apache.parquet.io.api.RecordMaterializer;
import shaded.org.apache.parquet.schema.MessageType;

public class QingStorageRecordReader
implements Closeable {
    private static final Log a = Log.getLog(QingStorageRecordReader.class);
    private ColumnIOFactory b = null;
    private final FilterCompat.Filter c;
    private MessageType d;
    private MessageType e;
    private Map f;
    private int g;
    private final b h;
    private RecordMaterializer i;
    private Object j;
    private long k;
    private long l = 0L;
    private int m = -1;
    private h n;
    private RecordReader o;
    private long p;
    private long q;
    private long r;
    private long s = 0L;
    private u t;

    public QingStorageRecordReader(b b2) {
        this(b2, FilterCompat.NOOP);
    }

    public QingStorageRecordReader(b b2, FilterCompat.Filter filter) {
        this.h = b2;
        this.c = Preconditions.checkNotNull(filter, "filter");
    }

    public QingStorageRecordReader(b b2, UnboundRecordFilter unboundRecordFilter) {
        this(b2, FilterCompat.get(unboundRecordFilter));
    }

    public void initialize(AbstractInputStream object, MessageType object2) throws IOException {
        Object object3;
        Iterator iterator;
        Object object4 = q.storage.columnar.h.a((AbstractInputStream)object, q.storage.columnar.metadata.a.a.a);
        FileMetaData fileMetaData = ((f)object4).b();
        MessageType messageType = fileMetaData.getSchema();
        if (!(object4 = q.storage.columnar.b.a.a.a(this.c, ((f)object4).a(), messageType)).isEmpty()) {
            iterator = (q.storage.columnar.metadata.a)object4.get(0);
            object3 = fileMetaData;
            HashSet hashSet = new HashSet();
            for (Object object5 : ((q.storage.columnar.metadata.a)((Object)iterator)).d()) {
                hashSet.addAll(object5.k());
            }
            for (Object object5 : hashSet) {
                if (!CorruptDeltaByteArrays.requiresSequentialReads(((FileMetaData)object3).getCreatedBy(), (Encoding)((Object)object5))) continue;
                throw new ParquetDecodingException("Cannot read data due to PARQUET-246.");
            }
        }
        object3 = fileMetaData.getKeyValueMetaData();
        iterator = this.h.init(new q.storage.columnar.api.a(QingStorageRecordReader.a((Map)object3), messageType));
        ((c)((Object)iterator)).a((MessageType)object2);
        this.b = new ColumnIOFactory(fileMetaData.getCreatedBy());
        this.d = object2;
        this.e = messageType;
        this.f = fileMetaData.getKeyValueMetaData();
        this.g = ((MessageType)object2).getPaths().size();
        this.i = this.h.prepareForRead((Map)object3, messageType, (c)((Object)iterator));
        object2 = ((MessageType)object2).getColumns();
        this.n = new h(fileMetaData, (AbstractInputStream)object, (List)object4, (List)object2);
        object = object4.iterator();
        while (object.hasNext()) {
            object2 = (q.storage.columnar.metadata.a)object.next();
            this.k += ((q.storage.columnar.metadata.a)object2).b();
        }
        this.t = new u(this.k);
        a.info("RecordReader initialized will read a total of " + this.k + " records.");
    }

    public MessageType getFileSchema() {
        return this.e;
    }

    public Map getExtraMetaData() {
        return this.f;
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        boolean bl = false;
        while (!bl) {
            if (this.l >= this.k) {
                return false;
            }
            try {
                QingStorageRecordReader qingStorageRecordReader = this;
                if (qingStorageRecordReader.l == qingStorageRecordReader.s) {
                    long l2;
                    if (qingStorageRecordReader.l != 0L) {
                        qingStorageRecordReader.q += System.currentTimeMillis() - qingStorageRecordReader.r;
                        if (Log.INFO) {
                            a.info("Assembled and processed " + qingStorageRecordReader.s + " records from " + qingStorageRecordReader.g + " columns in " + qingStorageRecordReader.q + " ms: " + (float)qingStorageRecordReader.s / (float)qingStorageRecordReader.q + " rec/ms, " + (float)qingStorageRecordReader.s * (float)qingStorageRecordReader.g / (float)qingStorageRecordReader.q + " cell/ms");
                            l2 = qingStorageRecordReader.q + qingStorageRecordReader.p;
                            if (l2 != 0L) {
                                long l3 = 100L * qingStorageRecordReader.p / l2;
                                long l4 = 100L * qingStorageRecordReader.q / l2;
                                a.info("time spent so far " + l3 + "% reading (" + qingStorageRecordReader.p + " ms) and " + l4 + "% processing (" + qingStorageRecordReader.q + " ms)");
                            }
                        }
                    }
                    a.info("at row " + qingStorageRecordReader.l + ". reading next block");
                    l2 = System.currentTimeMillis();
                    PageReadStore pageReadStore = qingStorageRecordReader.n.a();
                    if (pageReadStore == null) {
                        throw new IOException("expecting more rows but reached last block. Read " + qingStorageRecordReader.l + " out of " + qingStorageRecordReader.k);
                    }
                    long l5 = System.currentTimeMillis() - l2;
                    qingStorageRecordReader.p += l5;
                    q.storage.columnar.util.a.a.c(l5);
                    if (Log.INFO) {
                        a.info("block read in memory in " + l5 + " ms. row count = " + pageReadStore.getRowCount());
                    }
                    if (Log.DEBUG) {
                        a.debug("initializing Record assembly with requested schema " + qingStorageRecordReader.d);
                    }
                    MessageColumnIO messageColumnIO = qingStorageRecordReader.b.getColumnIO(qingStorageRecordReader.d, qingStorageRecordReader.e);
                    qingStorageRecordReader.o = messageColumnIO.getRecordReader(pageReadStore, qingStorageRecordReader.i, qingStorageRecordReader.c);
                    qingStorageRecordReader.r = System.currentTimeMillis();
                    qingStorageRecordReader.s += pageReadStore.getRowCount();
                    ++qingStorageRecordReader.m;
                }
                ++this.l;
                try {
                    this.j = this.o.read();
                }
                catch (RecordMaterializer.RecordMaterializationException recordMaterializationException) {
                    this.t.a(recordMaterializationException);
                    if (!Log.DEBUG) continue;
                    a.debug("skipping a corrupt record");
                    continue;
                }
                if (this.o.shouldSkipCurrentRecord()) {
                    if (!Log.DEBUG) continue;
                    a.debug("skipping record");
                    continue;
                }
                if (this.j == null) {
                    this.l = this.s;
                    if (!Log.DEBUG) continue;
                    a.debug("filtered record reader reached end of block");
                    continue;
                }
                bl = true;
                if (!Log.DEBUG) continue;
                a.debug("read value: " + this.j);
            }
            catch (RuntimeException runtimeException) {
                throw new ParquetDecodingException(String.format("Can not read value at %d in block %d in the file", this.l, this.m), runtimeException);
            }
        }
        return true;
    }

    public void close() throws IOException {
        if (this.n != null) {
            this.n.close();
        }
    }

    public Object getCurrentValue() throws IOException, InterruptedException {
        return this.j;
    }

    public float getProgress() throws IOException, InterruptedException {
        return (float)this.l / (float)this.k;
    }

    private static Map a(Map object) {
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : object.entrySet()) {
            HashSet hashSet = new HashSet();
            hashSet.add(entry.getValue());
            hashMap.put(entry.getKey(), Collections.unmodifiableSet(hashSet));
        }
        return Collections.unmodifiableMap(hashMap);
    }
}

