/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shaded.org.apache.parquet.Preconditions;
import shaded.org.apache.parquet.SemanticVersion;
import shaded.org.apache.parquet.Strings;

public class VersionParser {
    public static final String FORMAT = "(.+) version ((.*) )?\\(build ?(.*)\\)";
    public static final Pattern PATTERN = Pattern.compile("(.+) version ((.*) )?\\(build ?(.*)\\)");

    public static ParsedVersion parse(String createdBy) throws VersionParseException {
        Matcher matcher = PATTERN.matcher(createdBy);
        if (!matcher.matches()) {
            throw new VersionParseException("Could not parse created_by: " + createdBy + " using format: " + FORMAT);
        }
        String application = matcher.group(1);
        String semver = matcher.group(3);
        String appBuildHash = matcher.group(4);
        if (Strings.isNullOrEmpty(application)) {
            throw new VersionParseException("application cannot be null or empty");
        }
        return new ParsedVersion(application, semver, appBuildHash);
    }

    public static class VersionParseException
    extends Exception {
        public VersionParseException(String message) {
            super(message);
        }
    }

    public static class ParsedVersion {
        public final String application;
        public final String version;
        public final String appBuildHash;
        private final boolean hasSemver;
        private final SemanticVersion semver;

        public ParsedVersion(String application, String version, String appBuildHash) {
            boolean hasSemver;
            SemanticVersion sv;
            Preconditions.checkArgument(!Strings.isNullOrEmpty(application), "application cannot be null or empty");
            this.application = application;
            this.version = Strings.isNullOrEmpty(version) ? null : version;
            this.appBuildHash = Strings.isNullOrEmpty(appBuildHash) ? null : appBuildHash;
            try {
                sv = SemanticVersion.parse(version);
                hasSemver = true;
            }
            catch (RuntimeException e2) {
                sv = null;
                hasSemver = false;
            }
            catch (SemanticVersion.SemanticVersionParseException e3) {
                sv = null;
                hasSemver = false;
            }
            this.semver = sv;
            this.hasSemver = hasSemver;
        }

        public boolean hasSemanticVersion() {
            return this.hasSemver;
        }

        public SemanticVersion getSemanticVersion() {
            return this.semver;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            ParsedVersion version = (ParsedVersion)o2;
            if (this.appBuildHash != null ? !this.appBuildHash.equals(version.appBuildHash) : version.appBuildHash != null) {
                return false;
            }
            if (this.application != null ? !this.application.equals(version.application) : version.application != null) {
                return false;
            }
            return !(this.version != null ? !this.version.equals(version.version) : version.version != null);
        }

        public int hashCode() {
            int result = this.application != null ? this.application.hashCode() : 0;
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            result = 31 * result + (this.appBuildHash != null ? this.appBuildHash.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ParsedVersion(application=" + this.application + ", semver=" + this.version + ", appBuildHash=" + this.appBuildHash + ')';
        }
    }
}

