/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.column.impl;

import shaded.org.apache.parquet.VersionParser;
import shaded.org.apache.parquet.column.ColumnDescriptor;
import shaded.org.apache.parquet.column.ColumnReadStore;
import shaded.org.apache.parquet.column.ColumnReader;
import shaded.org.apache.parquet.column.impl.ColumnReaderImpl;
import shaded.org.apache.parquet.column.page.PageReadStore;
import shaded.org.apache.parquet.column.page.PageReader;
import shaded.org.apache.parquet.io.api.Converter;
import shaded.org.apache.parquet.io.api.GroupConverter;
import shaded.org.apache.parquet.io.api.PrimitiveConverter;
import shaded.org.apache.parquet.schema.GroupType;
import shaded.org.apache.parquet.schema.MessageType;
import shaded.org.apache.parquet.schema.Type;

public class ColumnReadStoreImpl
implements ColumnReadStore {
    private final PageReadStore pageReadStore;
    private final GroupConverter recordConverter;
    private final MessageType schema;
    private final VersionParser.ParsedVersion writerVersion;

    public ColumnReadStoreImpl(PageReadStore pageReadStore, GroupConverter recordConverter, MessageType schema, String createdBy) {
        VersionParser.ParsedVersion version;
        this.pageReadStore = pageReadStore;
        this.recordConverter = recordConverter;
        this.schema = schema;
        try {
            version = VersionParser.parse(createdBy);
        }
        catch (RuntimeException e2) {
            version = null;
        }
        catch (VersionParser.VersionParseException e3) {
            version = null;
        }
        this.writerVersion = version;
    }

    @Override
    public ColumnReader getColumnReader(ColumnDescriptor path) {
        return this.newMemColumnReader(path, this.pageReadStore.getPageReader(path));
    }

    private ColumnReaderImpl newMemColumnReader(ColumnDescriptor path, PageReader pageReader) {
        PrimitiveConverter converter = this.getPrimitiveConverter(path);
        return new ColumnReaderImpl(path, pageReader, converter, this.writerVersion);
    }

    private PrimitiveConverter getPrimitiveConverter(ColumnDescriptor path) {
        Type currentType = this.schema;
        Converter currentConverter = this.recordConverter;
        for (String fieldName : path.getPath()) {
            GroupType groupType = currentType.asGroupType();
            int fieldIndex = groupType.getFieldIndex(fieldName);
            currentType = groupType.getType(fieldName);
            currentConverter = ((Converter)currentConverter).asGroupConverter().getConverter(fieldIndex);
        }
        PrimitiveConverter converter = currentConverter.asPrimitiveConverter();
        return converter;
    }
}

