/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.column.values.bitpacking;

import java.io.IOException;
import shaded.org.apache.parquet.bytes.BytesInput;
import shaded.org.apache.parquet.bytes.BytesUtils;
import shaded.org.apache.parquet.bytes.CapacityByteArrayOutputStream;
import shaded.org.apache.parquet.column.Encoding;
import shaded.org.apache.parquet.column.values.ValuesWriter;
import shaded.org.apache.parquet.column.values.bitpacking.BitPacking;
import shaded.org.apache.parquet.io.ParquetEncodingException;

public class BitPackingValuesWriter
extends ValuesWriter {
    private CapacityByteArrayOutputStream out;
    private BitPacking.BitPackingWriter bitPackingWriter;
    private int bitsPerValue;

    public BitPackingValuesWriter(int bound, int initialCapacity, int pageSize) {
        this.bitsPerValue = BytesUtils.getWidthFromMaxInt(bound);
        this.out = new CapacityByteArrayOutputStream(initialCapacity, pageSize);
        this.init();
    }

    private void init() {
        this.bitPackingWriter = BitPacking.getBitPackingWriter(this.bitsPerValue, this.out);
    }

    @Override
    public void writeInteger(int v) {
        try {
            this.bitPackingWriter.write(v);
        }
        catch (IOException e2) {
            throw new ParquetEncodingException(e2);
        }
    }

    @Override
    public long getBufferedSize() {
        return this.out.size();
    }

    @Override
    public BytesInput getBytes() {
        try {
            this.bitPackingWriter.finish();
            return BytesInput.from(this.out);
        }
        catch (IOException e2) {
            throw new ParquetEncodingException(e2);
        }
    }

    @Override
    public void reset() {
        this.out.reset();
        this.init();
    }

    @Override
    public long getAllocatedSize() {
        return this.out.getCapacity();
    }

    @Override
    public String memUsageString(String prefix) {
        return this.out.memUsageString(prefix);
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.BIT_PACKED;
    }
}

