/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.column.values.deltastrings;

import shaded.org.apache.parquet.bytes.BytesInput;
import shaded.org.apache.parquet.column.Encoding;
import shaded.org.apache.parquet.column.values.ValuesWriter;
import shaded.org.apache.parquet.column.values.delta.DeltaBinaryPackingValuesWriter;
import shaded.org.apache.parquet.column.values.deltalengthbytearray.DeltaLengthByteArrayValuesWriter;
import shaded.org.apache.parquet.io.api.Binary;

public class DeltaByteArrayWriter
extends ValuesWriter {
    private ValuesWriter prefixLengthWriter;
    private ValuesWriter suffixWriter;
    private byte[] previous;

    public DeltaByteArrayWriter(int initialCapacity, int pageSize) {
        this.prefixLengthWriter = new DeltaBinaryPackingValuesWriter(128, 4, initialCapacity, pageSize);
        this.suffixWriter = new DeltaLengthByteArrayValuesWriter(initialCapacity, pageSize);
        this.previous = new byte[0];
    }

    @Override
    public long getBufferedSize() {
        return this.prefixLengthWriter.getBufferedSize() + this.suffixWriter.getBufferedSize();
    }

    @Override
    public BytesInput getBytes() {
        return BytesInput.concat(this.prefixLengthWriter.getBytes(), this.suffixWriter.getBytes());
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.DELTA_BYTE_ARRAY;
    }

    @Override
    public void reset() {
        this.prefixLengthWriter.reset();
        this.suffixWriter.reset();
        this.previous = new byte[0];
    }

    @Override
    public long getAllocatedSize() {
        return this.prefixLengthWriter.getAllocatedSize() + this.suffixWriter.getAllocatedSize();
    }

    @Override
    public String memUsageString(String prefix) {
        prefix = this.prefixLengthWriter.memUsageString(prefix);
        return this.suffixWriter.memUsageString(prefix + "  DELTA_STRINGS");
    }

    @Override
    public void writeBytes(Binary v) {
        int i2 = 0;
        byte[] vb = v.getBytes();
        int length = this.previous.length < vb.length ? this.previous.length : vb.length;
        for (i2 = 0; i2 < length && this.previous[i2] == vb[i2]; ++i2) {
        }
        this.prefixLengthWriter.writeInteger(i2);
        this.suffixWriter.writeBytes(v.slice(i2, vb.length - i2));
        this.previous = vb;
    }
}

