/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.column.values.plain;

import java.io.IOException;
import shaded.org.apache.parquet.Log;
import shaded.org.apache.parquet.bytes.BytesUtils;
import shaded.org.apache.parquet.column.values.ValuesReader;
import shaded.org.apache.parquet.io.ParquetDecodingException;
import shaded.org.apache.parquet.io.api.Binary;

public class BinaryPlainValuesReader
extends ValuesReader {
    private static final Log LOG = Log.getLog(BinaryPlainValuesReader.class);
    private byte[] in;
    private int offset;

    @Override
    public Binary readBytes() {
        try {
            int length = BytesUtils.readIntLittleEndian(this.in, this.offset);
            int start = this.offset + 4;
            this.offset = start + length;
            return Binary.fromConstantByteArray(this.in, start, length);
        }
        catch (IOException e2) {
            throw new ParquetDecodingException("could not read bytes at offset " + this.offset, e2);
        }
        catch (RuntimeException e3) {
            throw new ParquetDecodingException("could not read bytes at offset " + this.offset, e3);
        }
    }

    @Override
    public void skip() {
        try {
            int length = BytesUtils.readIntLittleEndian(this.in, this.offset);
            this.offset += 4 + length;
        }
        catch (IOException e2) {
            throw new ParquetDecodingException("could not skip bytes at offset " + this.offset, e2);
        }
        catch (RuntimeException e3) {
            throw new ParquetDecodingException("could not skip bytes at offset " + this.offset, e3);
        }
    }

    @Override
    public void initFromPage(int valueCount, byte[] in, int offset) throws IOException {
        if (Log.DEBUG) {
            LOG.debug("init from page at offset " + offset + " for length " + (in.length - offset));
        }
        this.in = in;
        this.offset = offset;
    }
}

