/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.example.data.simple.convert;

import shaded.org.apache.parquet.example.data.Group;
import shaded.org.apache.parquet.example.data.simple.convert.SimplePrimitiveConverter;
import shaded.org.apache.parquet.io.api.Converter;
import shaded.org.apache.parquet.io.api.GroupConverter;
import shaded.org.apache.parquet.schema.GroupType;
import shaded.org.apache.parquet.schema.Type;

class SimpleGroupConverter
extends GroupConverter {
    private final SimpleGroupConverter parent;
    private final int index;
    protected Group current;
    private Converter[] converters;

    SimpleGroupConverter(SimpleGroupConverter parent, int index, GroupType schema) {
        this.parent = parent;
        this.index = index;
        this.converters = new Converter[schema.getFieldCount()];
        for (int i2 = 0; i2 < this.converters.length; ++i2) {
            Type type = schema.getType(i2);
            this.converters[i2] = type.isPrimitive() ? new SimplePrimitiveConverter(this, i2) : new SimpleGroupConverter(this, i2, type.asGroupType());
        }
    }

    @Override
    public void start() {
        this.current = this.parent.getCurrentRecord().addGroup(this.index);
    }

    @Override
    public Converter getConverter(int fieldIndex) {
        return this.converters[fieldIndex];
    }

    @Override
    public void end() {
    }

    public Group getCurrentRecord() {
        return this.current;
    }
}

