/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.filter2.predicate;

import shaded.org.apache.parquet.Preconditions;
import shaded.org.apache.parquet.filter2.predicate.FilterApi;
import shaded.org.apache.parquet.filter2.predicate.FilterPredicate;
import shaded.org.apache.parquet.filter2.predicate.LogicalInverter;
import shaded.org.apache.parquet.filter2.predicate.Operators;
import shaded.org.apache.parquet.filter2.predicate.UserDefinedPredicate;

public final class LogicalInverseRewriter
implements FilterPredicate.Visitor<FilterPredicate> {
    private static final LogicalInverseRewriter INSTANCE = new LogicalInverseRewriter();

    public static FilterPredicate rewrite(FilterPredicate pred) {
        Preconditions.checkNotNull(pred, "pred");
        return pred.accept(INSTANCE);
    }

    private LogicalInverseRewriter() {
    }

    @Override
    public <T extends Comparable<T>> FilterPredicate visit(Operators.Eq<T> eq) {
        return eq;
    }

    @Override
    public <T extends Comparable<T>> FilterPredicate visit(Operators.NotEq<T> notEq) {
        return notEq;
    }

    @Override
    public <T extends Comparable<T>> FilterPredicate visit(Operators.Lt<T> lt) {
        return lt;
    }

    @Override
    public <T extends Comparable<T>> FilterPredicate visit(Operators.LtEq<T> ltEq) {
        return ltEq;
    }

    @Override
    public <T extends Comparable<T>> FilterPredicate visit(Operators.Gt<T> gt) {
        return gt;
    }

    @Override
    public <T extends Comparable<T>> FilterPredicate visit(Operators.GtEq<T> gtEq) {
        return gtEq;
    }

    @Override
    public FilterPredicate visit(Operators.And and) {
        return FilterApi.and(and.getLeft().accept(this), and.getRight().accept(this));
    }

    @Override
    public FilterPredicate visit(Operators.Or or) {
        return FilterApi.or(or.getLeft().accept(this), or.getRight().accept(this));
    }

    @Override
    public FilterPredicate visit(Operators.Not not) {
        return LogicalInverter.invert(not.getPredicate().accept(this));
    }

    @Override
    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> FilterPredicate visit(Operators.UserDefined<T, U> udp) {
        return udp;
    }

    @Override
    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> FilterPredicate visit(Operators.LogicalNotUserDefined<T, U> udp) {
        return udp;
    }
}

