/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.glob;

import java.util.ArrayList;
import java.util.Arrays;
import shaded.org.apache.parquet.glob.GlobNode;

final class GlobParser {
    private GlobParser() {
    }

    public static GlobNode.GlobNodeSequence parse(String pattern) {
        if (pattern.isEmpty() || pattern.equals("{}")) {
            return new GlobNode.GlobNodeSequence(Arrays.asList(new GlobNode.Atom("")));
        }
        ArrayList<GlobNode> children = new ArrayList<GlobNode>();
        int unmatchedBraces = 0;
        int firstBrace = 0;
        int anchor = 0;
        block5: for (int i2 = 0; i2 < pattern.length(); ++i2) {
            char c2 = pattern.charAt(i2);
            switch (c2) {
                case ',': {
                    if (unmatchedBraces != 0) continue block5;
                    throw new GlobParseException("Unexpected comma outside of a {} group:\n" + GlobParser.annotateMessage(pattern, i2));
                }
                case '{': {
                    if (unmatchedBraces == 0) {
                        firstBrace = i2;
                    }
                    ++unmatchedBraces;
                    continue block5;
                }
                case '}': {
                    if (--unmatchedBraces < 0) {
                        throw new GlobParseException("Unexpected closing }:\n" + GlobParser.annotateMessage(pattern, i2));
                    }
                    if (unmatchedBraces != 0) continue block5;
                    if (anchor != firstBrace) {
                        children.add(new GlobNode.Atom(pattern.substring(anchor, firstBrace)));
                    }
                    children.add(GlobParser.parseOneOf(pattern.substring(firstBrace + 1, i2)));
                    anchor = i2 + 1;
                }
            }
        }
        if (unmatchedBraces > 0) {
            throw new GlobParseException("Not enough close braces in: " + pattern);
        }
        if (anchor != pattern.length()) {
            children.add(new GlobNode.Atom(pattern.substring(anchor, pattern.length())));
        }
        return new GlobNode.GlobNodeSequence(children);
    }

    private static GlobNode.OneOf parseOneOf(String pattern) {
        ArrayList<GlobNode> children = new ArrayList<GlobNode>();
        int unmatchedBraces = 0;
        int anchor = 0;
        block5: for (int i2 = 0; i2 < pattern.length(); ++i2) {
            char c2 = pattern.charAt(i2);
            switch (c2) {
                case ',': {
                    if (unmatchedBraces != 0) continue block5;
                    children.add(GlobParser.parse(pattern.substring(anchor, i2)));
                    anchor = i2 + 1;
                    continue block5;
                }
                case '{': {
                    ++unmatchedBraces;
                    continue block5;
                }
                case '}': {
                    if (--unmatchedBraces >= 0) continue block5;
                    throw new GlobParseException("Unexpected closing }:\n" + GlobParser.annotateMessage(pattern, i2));
                }
            }
        }
        if (unmatchedBraces > 0) {
            throw new GlobParseException("Not enough close braces in: " + pattern);
        }
        if (anchor != pattern.length()) {
            children.add(GlobParser.parse(pattern.substring(anchor, pattern.length())));
        }
        if (pattern.length() > 0 && pattern.charAt(pattern.length() - 1) == ',') {
            children.add(GlobParser.parse(""));
        }
        return new GlobNode.OneOf(children);
    }

    private static String annotateMessage(String message, int pos) {
        StringBuilder sb = new StringBuilder(message);
        sb.append('\n');
        for (int i2 = 0; i2 < pos; ++i2) {
            sb.append('-');
        }
        sb.append('^');
        return sb.toString();
    }

    public static class GlobParseException
    extends RuntimeException {
        public GlobParseException() {
        }

        public GlobParseException(String message) {
            super(message);
        }

        public GlobParseException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

