/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.io;

import java.util.Arrays;
import java.util.List;
import shaded.org.apache.parquet.column.ColumnDescriptor;
import shaded.org.apache.parquet.io.ColumnIO;
import shaded.org.apache.parquet.io.GroupColumnIO;
import shaded.org.apache.parquet.schema.PrimitiveType;
import shaded.org.apache.parquet.schema.Type;

public class PrimitiveColumnIO
extends ColumnIO {
    private ColumnIO[] path;
    private ColumnDescriptor columnDescriptor;
    private final int id;

    PrimitiveColumnIO(Type type, GroupColumnIO parent, int index, int id) {
        super(type, parent, index);
        this.id = id;
    }

    @Override
    void setLevels(int r2, int d2, String[] fieldPath, int[] fieldIndexPath, List<ColumnIO> repetition, List<ColumnIO> path) {
        super.setLevels(r2, d2, fieldPath, fieldIndexPath, repetition, path);
        PrimitiveType type = this.getType().asPrimitiveType();
        this.columnDescriptor = new ColumnDescriptor(fieldPath, type.getPrimitiveTypeName(), type.getTypeLength(), this.getRepetitionLevel(), this.getDefinitionLevel());
        this.path = path.toArray(new ColumnIO[path.size()]);
    }

    @Override
    List<String[]> getColumnNames() {
        return Arrays.asList(new String[][]{this.getFieldPath()});
    }

    public ColumnDescriptor getColumnDescriptor() {
        return this.columnDescriptor;
    }

    public ColumnIO[] getPath() {
        return this.path;
    }

    public boolean isLast(int r2) {
        return this.getLast(r2) == this;
    }

    private PrimitiveColumnIO getLast(int r2) {
        ColumnIO parent = this.getParent(r2);
        PrimitiveColumnIO last = parent.getLast();
        return last;
    }

    @Override
    PrimitiveColumnIO getLast() {
        return this;
    }

    @Override
    PrimitiveColumnIO getFirst() {
        return this;
    }

    public boolean isFirst(int r2) {
        return this.getFirst(r2) == this;
    }

    private PrimitiveColumnIO getFirst(int r2) {
        ColumnIO parent = this.getParent(r2);
        return parent.getFirst();
    }

    public PrimitiveType.PrimitiveTypeName getPrimitive() {
        return this.getType().asPrimitiveType().getPrimitiveTypeName();
    }

    public int getId() {
        return this.id;
    }
}

