/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.io;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import shaded.org.apache.parquet.Log;
import shaded.org.apache.parquet.column.ColumnReader;
import shaded.org.apache.parquet.column.impl.ColumnReadStoreImpl;
import shaded.org.apache.parquet.io.ColumnIO;
import shaded.org.apache.parquet.io.MessageColumnIO;
import shaded.org.apache.parquet.io.ParquetEncodingException;
import shaded.org.apache.parquet.io.PrimitiveColumnIO;
import shaded.org.apache.parquet.io.RecordConsumerLoggingWrapper;
import shaded.org.apache.parquet.io.RecordReader;
import shaded.org.apache.parquet.io.ValidatingRecordConsumer;
import shaded.org.apache.parquet.io.api.Converter;
import shaded.org.apache.parquet.io.api.GroupConverter;
import shaded.org.apache.parquet.io.api.PrimitiveConverter;
import shaded.org.apache.parquet.io.api.RecordConsumer;
import shaded.org.apache.parquet.io.api.RecordMaterializer;
import shaded.org.apache.parquet.schema.MessageType;
import shaded.org.apache.parquet.schema.PrimitiveType;

class RecordReaderImplementation<T>
extends RecordReader<T> {
    private static final Log LOG = Log.getLog(RecordReaderImplementation.class);
    private final GroupConverter recordRootConverter;
    private final RecordMaterializer<T> recordMaterializer;
    private State[] states;
    private ColumnReader[] columnReaders;
    private boolean shouldSkipCurrentRecord = false;

    public RecordReaderImplementation(MessageColumnIO root, RecordMaterializer<T> recordMaterializer, boolean validating, ColumnReadStoreImpl columnStore) {
        State state;
        int i2;
        this.recordMaterializer = recordMaterializer;
        this.recordRootConverter = recordMaterializer.getRootConverter();
        PrimitiveColumnIO[] leaves = root.getLeaves().toArray(new PrimitiveColumnIO[root.getLeaves().size()]);
        this.columnReaders = new ColumnReader[leaves.length];
        int[][] nextColumnIdxForRepLevel = new int[leaves.length][];
        int[][] levelToClose = new int[leaves.length][];
        GroupConverter[][] groupConverterPaths = new GroupConverter[leaves.length][];
        PrimitiveConverter[] leafConverters = new PrimitiveConverter[leaves.length];
        int[] firstIndexForLevel = new int[256];
        for (i2 = 0; i2 < leaves.length; ++i2) {
            PrimitiveColumnIO leafColumnIO = leaves[i2];
            int[] indexFieldPath = leafColumnIO.getIndexFieldPath();
            groupConverterPaths[i2] = new GroupConverter[indexFieldPath.length - 1];
            GroupConverter current = this.recordRootConverter;
            for (int j2 = 0; j2 < indexFieldPath.length - 1; ++j2) {
                groupConverterPaths[i2][j2] = current = current.getConverter(indexFieldPath[j2]).asGroupConverter();
            }
            leafConverters[i2] = current.getConverter(indexFieldPath[indexFieldPath.length - 1]).asPrimitiveConverter();
            this.columnReaders[i2] = columnStore.getColumnReader(leafColumnIO.getColumnDescriptor());
            int maxRepetitionLevel = leafColumnIO.getRepetitionLevel();
            nextColumnIdxForRepLevel[i2] = new int[maxRepetitionLevel + 1];
            levelToClose[i2] = new int[maxRepetitionLevel + 1];
            for (int nextRepLevel = 0; nextRepLevel <= maxRepetitionLevel; ++nextRepLevel) {
                int nextColIdx;
                if (leafColumnIO.isFirst(nextRepLevel)) {
                    firstIndexForLevel[nextRepLevel] = i2;
                }
                if ((nextColIdx = nextRepLevel == 0 ? i2 + 1 : (leafColumnIO.isLast(nextRepLevel) ? firstIndexForLevel[nextRepLevel] : i2 + 1)) == leaves.length) {
                    levelToClose[i2][nextRepLevel] = 0;
                } else if (leafColumnIO.isLast(nextRepLevel)) {
                    ColumnIO parent = leafColumnIO.getParent(nextRepLevel);
                    levelToClose[i2][nextRepLevel] = parent.getFieldPath().length - 1;
                } else {
                    levelToClose[i2][nextRepLevel] = this.getCommonParentLevel(leafColumnIO.getFieldPath(), leaves[nextColIdx].getFieldPath());
                }
                if (levelToClose[i2][nextRepLevel] > leaves[i2].getFieldPath().length - 1) {
                    throw new ParquetEncodingException(Arrays.toString(leaves[i2].getFieldPath()) + " -(" + nextRepLevel + ")-> " + levelToClose[i2][nextRepLevel]);
                }
                nextColumnIdxForRepLevel[i2][nextRepLevel] = nextColIdx;
            }
        }
        this.states = new State[leaves.length];
        for (i2 = 0; i2 < leaves.length; ++i2) {
            this.states[i2] = new State(i2, leaves[i2], this.columnReaders[i2], levelToClose[i2], groupConverterPaths[i2], leafConverters[i2]);
            int[] definitionLevelToDepth = new int[this.states[i2].primitiveColumnIO.getDefinitionLevel() + 1];
            ColumnIO[] path = this.states[i2].primitiveColumnIO.getPath();
            int depth = 0;
            for (int d2 = 0; d2 < definitionLevelToDepth.length; ++d2) {
                while (depth < this.states[i2].fieldPath.length - 1 && d2 >= path[depth + 1].getDefinitionLevel()) {
                    ++depth;
                }
                definitionLevelToDepth[d2] = depth - 1;
            }
            State.access$102(this.states[i2], definitionLevelToDepth);
        }
        for (i2 = 0; i2 < leaves.length; ++i2) {
            state = this.states[i2];
            int[] nextStateIds = nextColumnIdxForRepLevel[i2];
            State.access$202(state, new State[nextStateIds.length]);
            for (int j3 = 0; j3 < nextStateIds.length; ++j3) {
                ((State)state).nextState[j3] = nextStateIds[j3] == this.states.length ? null : this.states[nextStateIds[j3]];
            }
        }
        for (i2 = 0; i2 < this.states.length; ++i2) {
            state = this.states[i2];
            HashMap<Case, Case> definedCases = new HashMap<Case, Case>();
            HashMap undefinedCases = new HashMap();
            Case[][][] caseLookup = new Case[state.fieldPath.length][][];
            for (int currentLevel = 0; currentLevel < state.fieldPath.length; ++currentLevel) {
                caseLookup[currentLevel] = new Case[state.maxDefinitionLevel + 1][];
                for (int d3 = 0; d3 <= state.maxDefinitionLevel; ++d3) {
                    caseLookup[currentLevel][d3] = new Case[state.maxRepetitionLevel + 1];
                    for (int nextR = 0; nextR <= state.maxRepetitionLevel; ++nextR) {
                        HashMap<Case, Case> cases;
                        int caseStartLevel = currentLevel;
                        int caseDepth = Math.max(state.getDepth(d3), caseStartLevel - 1);
                        int caseNextLevel = Math.min(state.nextLevel[nextR], caseDepth + 1);
                        Case currentCase = new Case(caseStartLevel, caseDepth, caseNextLevel, this.getNextReader(state.id, nextR), d3 == state.maxDefinitionLevel);
                        HashMap<Case, Case> hashMap = cases = currentCase.isDefined() ? definedCases : undefinedCases;
                        if (!cases.containsKey(currentCase)) {
                            currentCase.setID(cases.size());
                            cases.put(currentCase, currentCase);
                        } else {
                            currentCase = (Case)cases.get(currentCase);
                        }
                        caseLookup[currentLevel][d3][nextR] = currentCase;
                    }
                }
            }
            State.access$302(state, caseLookup);
            state.definedCases = new ArrayList(definedCases.values());
            state.undefinedCases = new ArrayList(undefinedCases.values());
            Comparator<Case> caseComparator = new Comparator<Case>(){

                @Override
                public int compare(Case o1, Case o2) {
                    return o1.id - o2.id;
                }
            };
            Collections.sort(state.definedCases, caseComparator);
            Collections.sort(state.undefinedCases, caseComparator);
        }
    }

    private RecordConsumer validator(RecordConsumer recordConsumer, boolean validating, MessageType schema) {
        return validating ? new ValidatingRecordConsumer(recordConsumer, schema) : recordConsumer;
    }

    private RecordConsumer wrap(RecordConsumer recordConsumer) {
        if (Log.DEBUG) {
            return new RecordConsumerLoggingWrapper(recordConsumer);
        }
        return recordConsumer;
    }

    @Override
    public T read() {
        int nextR;
        int currentLevel = 0;
        this.recordRootConverter.start();
        State currentState = this.states[0];
        do {
            ColumnReader columnReader = currentState.column;
            int d2 = columnReader.getCurrentDefinitionLevel();
            int depth = currentState.definitionLevelToDepth[d2];
            while (currentLevel <= depth) {
                currentState.groupConverterPath[currentLevel].start();
                ++currentLevel;
            }
            if (d2 >= currentState.maxDefinitionLevel) {
                columnReader.writeCurrentValueToConverter();
            }
            columnReader.consume();
            nextR = currentState.maxRepetitionLevel == 0 ? 0 : columnReader.getCurrentRepetitionLevel();
            int next = currentState.nextLevel[nextR];
            while (currentLevel > next) {
                currentState.groupConverterPath[currentLevel - 1].end();
                --currentLevel;
            }
        } while ((currentState = currentState.nextState[nextR]) != null);
        this.recordRootConverter.end();
        T record = this.recordMaterializer.getCurrentRecord();
        boolean bl = this.shouldSkipCurrentRecord = record == null;
        if (this.shouldSkipCurrentRecord) {
            this.recordMaterializer.skipCurrentRecord();
        }
        return record;
    }

    @Override
    public boolean shouldSkipCurrentRecord() {
        return this.shouldSkipCurrentRecord;
    }

    private static void log(String string) {
        LOG.debug(string);
    }

    int getNextReader(int current, int nextRepetitionLevel) {
        State nextState = this.states[current].nextState[nextRepetitionLevel];
        return nextState == null ? this.states.length : nextState.id;
    }

    int getNextLevel(int current, int nextRepetitionLevel) {
        return this.states[current].nextLevel[nextRepetitionLevel];
    }

    private int getCommonParentLevel(String[] previous, String[] next) {
        int i2;
        for (i2 = 0; i2 < Math.min(previous.length, next.length) && previous[i2].equals(next[i2]); ++i2) {
        }
        return i2;
    }

    protected int getStateCount() {
        return this.states.length;
    }

    protected State getState(int i2) {
        return this.states[i2];
    }

    protected RecordMaterializer<T> getMaterializer() {
        return this.recordMaterializer;
    }

    protected Converter getRecordConsumer() {
        return this.recordRootConverter;
    }

    protected Iterable<ColumnReader> getColumnReaders() {
        return Arrays.asList(this.columnReaders);
    }

    public static class State {
        public final int id;
        public final PrimitiveColumnIO primitiveColumnIO;
        public final int maxDefinitionLevel;
        public final int maxRepetitionLevel;
        public final PrimitiveType.PrimitiveTypeName primitive;
        public final ColumnReader column;
        public final String[] fieldPath;
        public final int[] indexFieldPath;
        public final GroupConverter[] groupConverterPath;
        public final PrimitiveConverter primitiveConverter;
        public final String primitiveField;
        public final int primitiveFieldIndex;
        public final int[] nextLevel;
        private int[] definitionLevelToDepth;
        private State[] nextState;
        private Case[][][] caseLookup;
        private List<Case> definedCases;
        private List<Case> undefinedCases;

        private State(int id, PrimitiveColumnIO primitiveColumnIO, ColumnReader column, int[] nextLevel, GroupConverter[] groupConverterPath, PrimitiveConverter primitiveConverter) {
            this.id = id;
            this.primitiveColumnIO = primitiveColumnIO;
            this.maxDefinitionLevel = primitiveColumnIO.getDefinitionLevel();
            this.maxRepetitionLevel = primitiveColumnIO.getRepetitionLevel();
            this.column = column;
            this.nextLevel = nextLevel;
            this.groupConverterPath = groupConverterPath;
            this.primitiveConverter = primitiveConverter;
            this.primitive = primitiveColumnIO.getType().asPrimitiveType().getPrimitiveTypeName();
            this.fieldPath = primitiveColumnIO.getFieldPath();
            this.primitiveField = this.fieldPath[this.fieldPath.length - 1];
            this.indexFieldPath = primitiveColumnIO.getIndexFieldPath();
            this.primitiveFieldIndex = this.indexFieldPath[this.indexFieldPath.length - 1];
        }

        public int getDepth(int definitionLevel) {
            return this.definitionLevelToDepth[definitionLevel];
        }

        public List<Case> getDefinedCases() {
            return this.definedCases;
        }

        public List<Case> getUndefinedCases() {
            return this.undefinedCases;
        }

        public Case getCase(int currentLevel, int d2, int nextR) {
            return this.caseLookup[currentLevel][d2][nextR];
        }

        public State getNextState(int nextR) {
            return this.nextState[nextR];
        }

        static /* synthetic */ int[] access$102(State x0, int[] x1) {
            x0.definitionLevelToDepth = x1;
            return x1;
        }

        static /* synthetic */ State[] access$202(State x0, State[] x1) {
            x0.nextState = x1;
            return x1;
        }

        static /* synthetic */ Case[][][] access$302(State x0, Case[][][] x1) {
            x0.caseLookup = x1;
            return x1;
        }
    }

    public static class Case {
        private int id;
        private final int startLevel;
        private final int depth;
        private final int nextLevel;
        private final boolean goingUp;
        private final boolean goingDown;
        private final int nextState;
        private final boolean defined;

        public Case(int startLevel, int depth, int nextLevel, int nextState, boolean defined) {
            this.startLevel = startLevel;
            this.depth = depth;
            this.nextLevel = nextLevel;
            this.nextState = nextState;
            this.defined = defined;
            this.goingUp = startLevel <= depth;
            this.goingDown = depth + 1 > nextLevel;
        }

        public void setID(int id) {
            this.id = id;
        }

        public int hashCode() {
            int hashCode = 17;
            hashCode += 31 * this.startLevel;
            hashCode += 31 * this.depth;
            hashCode += 31 * this.nextLevel;
            hashCode += 31 * this.nextState;
            return hashCode += 31 * (this.defined ? 0 : 1);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Case) {
                return this.equals((Case)obj);
            }
            return false;
        }

        public boolean equals(Case other) {
            return this.startLevel == other.startLevel && this.depth == other.depth && this.nextLevel == other.nextLevel && this.nextState == other.nextState && (this.defined && other.defined || !this.defined && !other.defined);
        }

        public int getID() {
            return this.id;
        }

        public int getStartLevel() {
            return this.startLevel;
        }

        public int getDepth() {
            return this.depth;
        }

        public int getNextLevel() {
            return this.nextLevel;
        }

        public int getNextState() {
            return this.nextState;
        }

        public boolean isGoingUp() {
            return this.goingUp;
        }

        public boolean isGoingDown() {
            return this.goingDown;
        }

        public boolean isDefined() {
            return this.defined;
        }

        public String toString() {
            return "Case " + this.startLevel + " -> " + this.depth + " -> " + this.nextLevel + "; goto sate_" + this.getNextState();
        }
    }
}

