/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.it.unimi.dsi.fastutil.booleans;

import java.io.Serializable;
import java.util.Random;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.Arrays;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.Hash;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.booleans.BooleanComparator;

public class BooleanArrays {
    public static final boolean[] EMPTY_ARRAY = new boolean[0];
    private static final int SMALL = 7;
    private static final int MEDIUM = 50;
    public static final Hash.Strategy<boolean[]> HASH_STRATEGY = new ArrayHashStrategy();

    private BooleanArrays() {
    }

    public static boolean[] ensureCapacity(boolean[] array, int length) {
        if (length > array.length) {
            boolean[] t2 = new boolean[length];
            System.arraycopy(array, 0, t2, 0, array.length);
            return t2;
        }
        return array;
    }

    public static boolean[] ensureCapacity(boolean[] array, int length, int preserve) {
        if (length > array.length) {
            boolean[] t2 = new boolean[length];
            System.arraycopy(array, 0, t2, 0, preserve);
            return t2;
        }
        return array;
    }

    public static boolean[] grow(boolean[] array, int length) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(2L * (long)array.length, (long)length), 0x7FFFFFF7L);
            boolean[] t2 = new boolean[newLength];
            System.arraycopy(array, 0, t2, 0, array.length);
            return t2;
        }
        return array;
    }

    public static boolean[] grow(boolean[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(2L * (long)array.length, (long)length), 0x7FFFFFF7L);
            boolean[] t2 = new boolean[newLength];
            System.arraycopy(array, 0, t2, 0, preserve);
            return t2;
        }
        return array;
    }

    public static boolean[] trim(boolean[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        boolean[] t2 = length == 0 ? EMPTY_ARRAY : new boolean[length];
        System.arraycopy(array, 0, t2, 0, length);
        return t2;
    }

    public static boolean[] setLength(boolean[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return BooleanArrays.trim(array, length);
        }
        return BooleanArrays.ensureCapacity(array, length);
    }

    public static boolean[] copy(boolean[] array, int offset, int length) {
        BooleanArrays.ensureOffsetLength(array, offset, length);
        boolean[] a2 = length == 0 ? EMPTY_ARRAY : new boolean[length];
        System.arraycopy(array, offset, a2, 0, length);
        return a2;
    }

    public static boolean[] copy(boolean[] array) {
        return (boolean[])array.clone();
    }

    public static void fill(boolean[] array, boolean value) {
        int i2 = array.length;
        while (i2-- != 0) {
            array[i2] = value;
        }
    }

    public static void fill(boolean[] array, int from, int to, boolean value) {
        BooleanArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i2 = from; i2 < to; ++i2) {
                array[i2] = value;
            }
        }
    }

    @Deprecated
    public static boolean equals(boolean[] a1, boolean[] a2) {
        int i2 = a1.length;
        if (i2 != a2.length) {
            return false;
        }
        while (i2-- != 0) {
            if (a1[i2] == a2[i2]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(boolean[] a2, int from, int to) {
        Arrays.ensureFromTo(a2.length, from, to);
    }

    public static void ensureOffsetLength(boolean[] a2, int offset, int length) {
        Arrays.ensureOffsetLength(a2.length, offset, length);
    }

    private static void swap(boolean[] x, int a2, int b2) {
        boolean t2 = x[a2];
        x[a2] = x[b2];
        x[b2] = t2;
    }

    private static void vecSwap(boolean[] x, int a2, int b2, int n2) {
        int i2 = 0;
        while (i2 < n2) {
            BooleanArrays.swap(x, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static int med3(boolean[] x, int a2, int b2, int c2, BooleanComparator comp) {
        int ab = comp.compare(x[a2], x[b2]);
        int ac = comp.compare(x[a2], x[c2]);
        int bc = comp.compare(x[b2], x[c2]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    private static void selectionSort(boolean[] a2, int from, int to, BooleanComparator comp) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m2 = i2;
            for (int j2 = i2 + 1; j2 < to; ++j2) {
                if (comp.compare(a2[j2], a2[m2]) >= 0) continue;
                m2 = j2;
            }
            if (m2 == i2) continue;
            boolean u2 = a2[i2];
            a2[i2] = a2[m2];
            a2[m2] = u2;
        }
    }

    private static void insertionSort(boolean[] a2, int from, int to, BooleanComparator comp) {
        int i2 = from;
        while (++i2 < to) {
            boolean t2 = a2[i2];
            int j2 = i2;
            boolean u2 = a2[j2 - 1];
            while (comp.compare(t2, u2) < 0) {
                a2[j2] = u2;
                if (from == j2 - 1) {
                    --j2;
                    break;
                }
                u2 = a2[--j2 - 1];
            }
            a2[j2] = t2;
        }
    }

    private static void selectionSort(boolean[] a2, int from, int to) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m2 = i2;
            for (int j2 = i2 + 1; j2 < to; ++j2) {
                if (a2[j2] || !a2[m2]) continue;
                m2 = j2;
            }
            if (m2 == i2) continue;
            boolean u2 = a2[i2];
            a2[i2] = a2[m2];
            a2[m2] = u2;
        }
    }

    private static void insertionSort(boolean[] a2, int from, int to) {
        int i2 = from;
        while (++i2 < to) {
            boolean t2 = a2[i2];
            int j2 = i2;
            boolean u2 = a2[j2 - 1];
            while (!t2 && u2) {
                a2[j2] = u2;
                if (from == j2 - 1) {
                    --j2;
                    break;
                }
                u2 = a2[--j2 - 1];
            }
            a2[j2] = t2;
        }
    }

    public static void quickSort(boolean[] x, int from, int to, BooleanComparator comp) {
        int c2;
        int a2;
        int len = to - from;
        if (len < 7) {
            BooleanArrays.selectionSort(x, from, to, comp);
            return;
        }
        int m2 = from + len / 2;
        if (len > 7) {
            int l2 = from;
            int n2 = to - 1;
            if (len > 50) {
                int s2 = len / 8;
                l2 = BooleanArrays.med3(x, l2, l2 + s2, l2 + 2 * s2, comp);
                m2 = BooleanArrays.med3(x, m2 - s2, m2, m2 + s2, comp);
                n2 = BooleanArrays.med3(x, n2 - 2 * s2, n2 - s2, n2, comp);
            }
            m2 = BooleanArrays.med3(x, l2, m2, n2, comp);
        }
        boolean v = x[m2];
        int b2 = a2 = from;
        int d2 = c2 = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c2 && (comparison = comp.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (comparison = comp.compare(x[c2], v)) >= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            BooleanArrays.swap(x, b2++, c2--);
        }
        int n3 = to;
        int s3 = Math.min(a2 - from, b2 - a2);
        BooleanArrays.vecSwap(x, from, b2 - s3, s3);
        s3 = Math.min(d2 - c2, n3 - d2 - 1);
        BooleanArrays.vecSwap(x, b2, n3 - s3, s3);
        s3 = b2 - a2;
        if (s3 > 1) {
            BooleanArrays.quickSort(x, from, from + s3, comp);
        }
        if ((s3 = d2 - c2) > 1) {
            BooleanArrays.quickSort(x, n3 - s3, n3, comp);
        }
    }

    public static void quickSort(boolean[] x, BooleanComparator comp) {
        BooleanArrays.quickSort(x, 0, x.length, comp);
    }

    private static int med3(boolean[] x, int a2, int b2, int c2) {
        int bc;
        int ac;
        int ab;
        int n2 = !x[a2] && x[b2] ? -1 : (ab = x[a2] == x[b2] ? 0 : 1);
        int n3 = !x[a2] && x[c2] ? -1 : (ac = x[a2] == x[c2] ? 0 : 1);
        int n4 = !x[b2] && x[c2] ? -1 : (bc = x[b2] == x[c2] ? 0 : 1);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    @Deprecated
    public static void quickSort(boolean[] x, int from, int to) {
        int c2;
        int a2;
        int len = to - from;
        if (len < 7) {
            BooleanArrays.selectionSort(x, from, to);
            return;
        }
        int m2 = from + len / 2;
        if (len > 7) {
            int l2 = from;
            int n2 = to - 1;
            if (len > 50) {
                int s2 = len / 8;
                l2 = BooleanArrays.med3(x, l2, l2 + s2, l2 + 2 * s2);
                m2 = BooleanArrays.med3(x, m2 - s2, m2, m2 + s2);
                n2 = BooleanArrays.med3(x, n2 - 2 * s2, n2 - s2, n2);
            }
            m2 = BooleanArrays.med3(x, l2, m2, n2);
        }
        boolean v = x[m2];
        int b2 = a2 = from;
        int d2 = c2 = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c2 && (!x[b2] && v ? -1 : (comparison = x[b2] == v ? 0 : 1)) <= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (!x[c2] && v ? -1 : (comparison = x[c2] == v ? 0 : 1)) >= 0) {
                if (comparison == 0) {
                    BooleanArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            BooleanArrays.swap(x, b2++, c2--);
        }
        int n3 = to;
        int s3 = Math.min(a2 - from, b2 - a2);
        BooleanArrays.vecSwap(x, from, b2 - s3, s3);
        s3 = Math.min(d2 - c2, n3 - d2 - 1);
        BooleanArrays.vecSwap(x, b2, n3 - s3, s3);
        s3 = b2 - a2;
        if (s3 > 1) {
            BooleanArrays.quickSort(x, from, from + s3);
        }
        if ((s3 = d2 - c2) > 1) {
            BooleanArrays.quickSort(x, n3 - s3, n3);
        }
    }

    @Deprecated
    public static void quickSort(boolean[] x) {
        BooleanArrays.quickSort(x, 0, x.length);
    }

    public static void mergeSort(boolean[] a2, int from, int to, boolean[] supp) {
        int len = to - from;
        if (len < 7) {
            BooleanArrays.insertionSort(a2, from, to);
            return;
        }
        int mid = from + to >>> 1;
        BooleanArrays.mergeSort(supp, from, mid, a2);
        BooleanArrays.mergeSort(supp, mid, to, a2);
        if (!supp[mid - 1] || supp[mid]) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p2 = from;
        int q2 = mid;
        for (int i2 = from; i2 < to; ++i2) {
            a2[i2] = q2 >= to || p2 < mid && (!supp[p2] || supp[q2]) ? supp[p2++] : supp[q2++];
        }
    }

    public static void mergeSort(boolean[] a2, int from, int to) {
        BooleanArrays.mergeSort(a2, from, to, (boolean[])a2.clone());
    }

    public static void mergeSort(boolean[] a2) {
        BooleanArrays.mergeSort(a2, 0, a2.length);
    }

    public static void mergeSort(boolean[] a2, int from, int to, BooleanComparator comp, boolean[] supp) {
        int len = to - from;
        if (len < 7) {
            BooleanArrays.insertionSort(a2, from, to, comp);
            return;
        }
        int mid = from + to >>> 1;
        BooleanArrays.mergeSort(supp, from, mid, comp, a2);
        BooleanArrays.mergeSort(supp, mid, to, comp, a2);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p2 = from;
        int q2 = mid;
        for (int i2 = from; i2 < to; ++i2) {
            a2[i2] = q2 >= to || p2 < mid && comp.compare(supp[p2], supp[q2]) <= 0 ? supp[p2++] : supp[q2++];
        }
    }

    public static void mergeSort(boolean[] a2, int from, int to, BooleanComparator comp) {
        BooleanArrays.mergeSort(a2, from, to, comp, (boolean[])a2.clone());
    }

    public static void mergeSort(boolean[] a2, BooleanComparator comp) {
        BooleanArrays.mergeSort(a2, 0, a2.length, comp);
    }

    public static boolean[] shuffle(boolean[] a2, int from, int to, Random random) {
        int i2 = to - from;
        while (i2-- != 0) {
            int p2 = random.nextInt(i2 + 1);
            boolean t2 = a2[from + i2];
            a2[from + i2] = a2[from + p2];
            a2[from + p2] = t2;
        }
        return a2;
    }

    public static boolean[] shuffle(boolean[] a2, Random random) {
        int i2 = a2.length;
        while (i2-- != 0) {
            int p2 = random.nextInt(i2 + 1);
            boolean t2 = a2[i2];
            a2[i2] = a2[p2];
            a2[p2] = t2;
        }
        return a2;
    }

    public static boolean[] reverse(boolean[] a2) {
        int length = a2.length;
        int i2 = length / 2;
        while (i2-- != 0) {
            boolean t2 = a2[length - i2 - 1];
            a2[length - i2 - 1] = a2[i2];
            a2[i2] = t2;
        }
        return a2;
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<boolean[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(boolean[] o2) {
            return java.util.Arrays.hashCode(o2);
        }

        @Override
        public boolean equals(boolean[] a2, boolean[] b2) {
            return java.util.Arrays.equals(a2, b2);
        }
    }
}

