/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.it.unimi.dsi.fastutil.doubles;

import java.io.Serializable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.bytes.ByteIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.doubles.AbstractDoubleBidirectionalIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.doubles.AbstractDoubleIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.doubles.AbstractDoubleListIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.doubles.DoubleArrays;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.doubles.DoubleBidirectionalIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.doubles.DoubleCollection;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.doubles.DoubleIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.doubles.DoubleList;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.floats.FloatIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.ints.IntIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.shorts.ShortIterator;

public class DoubleIterators {
    public static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();

    private DoubleIterators() {
    }

    public static DoubleListIterator singleton(double element) {
        return new SingletonIterator(element);
    }

    public static DoubleListIterator wrap(double[] array, int offset, int length) {
        DoubleArrays.ensureOffsetLength(array, offset, length);
        return new ArrayIterator(array, offset, length);
    }

    public static DoubleListIterator wrap(double[] array) {
        return new ArrayIterator(array, 0, array.length);
    }

    public static int unwrap(DoubleIterator i2, double[] array, int offset, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        if (offset < 0 || offset + max > array.length) {
            throw new IllegalArgumentException();
        }
        int j2 = max;
        while (j2-- != 0 && i2.hasNext()) {
            array[offset++] = i2.nextDouble();
        }
        return max - j2 - 1;
    }

    public static int unwrap(DoubleIterator i2, double[] array) {
        return DoubleIterators.unwrap(i2, array, 0, array.length);
    }

    public static double[] unwrap(DoubleIterator i2, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        double[] array = new double[16];
        int j2 = 0;
        while (max-- != 0 && i2.hasNext()) {
            if (j2 == array.length) {
                array = DoubleArrays.grow(array, j2 + 1);
            }
            array[j2++] = i2.nextDouble();
        }
        return DoubleArrays.trim(array, j2);
    }

    public static double[] unwrap(DoubleIterator i2) {
        return DoubleIterators.unwrap(i2, Integer.MAX_VALUE);
    }

    public static int unwrap(DoubleIterator i2, DoubleCollection c2, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        int j2 = max;
        while (j2-- != 0 && i2.hasNext()) {
            c2.add(i2.nextDouble());
        }
        return max - j2 - 1;
    }

    public static long unwrap(DoubleIterator i2, DoubleCollection c2) {
        long n2 = 0L;
        while (i2.hasNext()) {
            c2.add(i2.nextDouble());
            ++n2;
        }
        return n2;
    }

    public static int pour(DoubleIterator i2, DoubleCollection s2, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        int j2 = max;
        while (j2-- != 0 && i2.hasNext()) {
            s2.add(i2.nextDouble());
        }
        return max - j2 - 1;
    }

    public static int pour(DoubleIterator i2, DoubleCollection s2) {
        return DoubleIterators.pour(i2, s2, Integer.MAX_VALUE);
    }

    public static DoubleList pour(DoubleIterator i2, int max) {
        DoubleArrayList l2 = new DoubleArrayList();
        DoubleIterators.pour(i2, l2, max);
        l2.trim();
        return l2;
    }

    public static DoubleList pour(DoubleIterator i2) {
        return DoubleIterators.pour(i2, Integer.MAX_VALUE);
    }

    public static DoubleIterator asDoubleIterator(Iterator i2) {
        if (i2 instanceof DoubleIterator) {
            return (DoubleIterator)i2;
        }
        return new IteratorWrapper(i2);
    }

    public static DoubleListIterator asDoubleIterator(ListIterator i2) {
        if (i2 instanceof DoubleListIterator) {
            return (DoubleListIterator)i2;
        }
        return new ListIteratorWrapper(i2);
    }

    public static DoubleIterator concat(DoubleIterator[] a2) {
        return DoubleIterators.concat(a2, 0, a2.length);
    }

    public static DoubleIterator concat(DoubleIterator[] a2, int offset, int length) {
        return new IteratorConcatenator(a2, offset, length);
    }

    public static DoubleIterator unmodifiable(DoubleIterator i2) {
        return new UnmodifiableIterator(i2);
    }

    public static DoubleBidirectionalIterator unmodifiable(DoubleBidirectionalIterator i2) {
        return new UnmodifiableBidirectionalIterator(i2);
    }

    public static DoubleListIterator unmodifiable(DoubleListIterator i2) {
        return new UnmodifiableListIterator(i2);
    }

    public static DoubleIterator wrap(ByteIterator iterator) {
        return new ByteIteratorWrapper(iterator);
    }

    public static DoubleIterator wrap(ShortIterator iterator) {
        return new ShortIteratorWrapper(iterator);
    }

    public static DoubleIterator wrap(IntIterator iterator) {
        return new IntIteratorWrapper(iterator);
    }

    public static DoubleIterator wrap(FloatIterator iterator) {
        return new FloatIteratorWrapper(iterator);
    }

    protected static class FloatIteratorWrapper
    implements DoubleIterator {
        final FloatIterator iterator;

        public FloatIteratorWrapper(FloatIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Double next() {
            return this.iterator.nextFloat();
        }

        @Override
        public double nextDouble() {
            return this.iterator.nextFloat();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public int skip(int n2) {
            return this.iterator.skip(n2);
        }
    }

    protected static class IntIteratorWrapper
    implements DoubleIterator {
        final IntIterator iterator;

        public IntIteratorWrapper(IntIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Double next() {
            return this.iterator.nextInt();
        }

        @Override
        public double nextDouble() {
            return this.iterator.nextInt();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public int skip(int n2) {
            return this.iterator.skip(n2);
        }
    }

    protected static class ShortIteratorWrapper
    implements DoubleIterator {
        final ShortIterator iterator;

        public ShortIteratorWrapper(ShortIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Double next() {
            return this.iterator.nextShort();
        }

        @Override
        public double nextDouble() {
            return this.iterator.nextShort();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public int skip(int n2) {
            return this.iterator.skip(n2);
        }
    }

    protected static class ByteIteratorWrapper
    implements DoubleIterator {
        final ByteIterator iterator;

        public ByteIteratorWrapper(ByteIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Double next() {
            return this.iterator.nextByte();
        }

        @Override
        public double nextDouble() {
            return this.iterator.nextByte();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public int skip(int n2) {
            return this.iterator.skip(n2);
        }
    }

    public static class UnmodifiableListIterator
    extends AbstractDoubleListIterator {
        protected final DoubleListIterator i;

        public UnmodifiableListIterator(DoubleListIterator i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        @Override
        public double nextDouble() {
            return this.i.nextDouble();
        }

        @Override
        public double previousDouble() {
            return this.i.previousDouble();
        }

        @Override
        public int nextIndex() {
            return this.i.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.i.previousIndex();
        }

        @Override
        public Double next() {
            return (Double)this.i.next();
        }

        @Override
        public Double previous() {
            return (Double)this.i.previous();
        }
    }

    public static class UnmodifiableBidirectionalIterator
    extends AbstractDoubleBidirectionalIterator {
        protected final DoubleBidirectionalIterator i;

        public UnmodifiableBidirectionalIterator(DoubleBidirectionalIterator i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        @Override
        public double nextDouble() {
            return this.i.nextDouble();
        }

        @Override
        public double previousDouble() {
            return this.i.previousDouble();
        }

        @Override
        public Double next() {
            return (Double)this.i.next();
        }

        @Override
        public Double previous() {
            return (Double)this.i.previous();
        }
    }

    public static class UnmodifiableIterator
    extends AbstractDoubleIterator {
        protected final DoubleIterator i;

        public UnmodifiableIterator(DoubleIterator i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public double nextDouble() {
            return this.i.nextDouble();
        }

        @Override
        public Double next() {
            return (Double)this.i.next();
        }
    }

    private static class IteratorConcatenator
    extends AbstractDoubleIterator {
        final DoubleIterator[] a;
        int offset;
        int length;
        int lastOffset = -1;

        public IteratorConcatenator(DoubleIterator[] a2, int offset, int length) {
            this.a = a2;
            this.offset = offset;
            this.length = length;
            this.advance();
        }

        private void advance() {
            while (this.length != 0 && !this.a[this.offset].hasNext()) {
                --this.length;
                ++this.offset;
            }
        }

        @Override
        public boolean hasNext() {
            return this.length > 0;
        }

        @Override
        public double nextDouble() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastOffset = this.offset;
            double next = this.a[this.lastOffset].nextDouble();
            this.advance();
            return next;
        }

        @Override
        public void remove() {
            if (this.lastOffset == -1) {
                throw new IllegalStateException();
            }
            this.a[this.lastOffset].remove();
        }

        @Override
        public int skip(int n2) {
            this.lastOffset = -1;
            int skipped = 0;
            while (skipped < n2 && this.length != 0) {
                skipped += this.a[this.offset].skip(n2 - skipped);
                if (this.a[this.offset].hasNext()) break;
                --this.length;
                ++this.offset;
            }
            return skipped;
        }
    }

    private static class ListIteratorWrapper
    extends AbstractDoubleListIterator {
        final ListIterator<Double> i;

        public ListIteratorWrapper(ListIterator<Double> i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.i.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.i.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.i.previousIndex();
        }

        @Override
        public void set(double k2) {
            this.i.set(k2);
        }

        @Override
        public void add(double k2) {
            this.i.add(k2);
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        @Override
        public double nextDouble() {
            return this.i.next();
        }

        @Override
        public double previousDouble() {
            return this.i.previous();
        }
    }

    private static class IteratorWrapper
    extends AbstractDoubleIterator {
        final Iterator<Double> i;

        public IteratorWrapper(Iterator<Double> i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        @Override
        public double nextDouble() {
            return this.i.next();
        }
    }

    private static class ArrayIterator
    extends AbstractDoubleListIterator {
        private final double[] array;
        private final int offset;
        private final int length;
        private int curr;

        public ArrayIterator(double[] array, int offset, int length) {
            this.array = array;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public boolean hasNext() {
            return this.curr < this.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.curr > 0;
        }

        @Override
        public double nextDouble() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.array[this.offset + this.curr++];
        }

        @Override
        public double previousDouble() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return this.array[this.offset + --this.curr];
        }

        @Override
        public int skip(int n2) {
            if (n2 <= this.length - this.curr) {
                this.curr += n2;
                return n2;
            }
            n2 = this.length - this.curr;
            this.curr = this.length;
            return n2;
        }

        @Override
        public int back(int n2) {
            if (n2 <= this.curr) {
                this.curr -= n2;
                return n2;
            }
            n2 = this.curr;
            this.curr = 0;
            return n2;
        }

        @Override
        public int nextIndex() {
            return this.curr;
        }

        @Override
        public int previousIndex() {
            return this.curr - 1;
        }
    }

    private static class SingletonIterator
    extends AbstractDoubleListIterator {
        private final double element;
        private int curr;

        public SingletonIterator(double element) {
            this.element = element;
        }

        @Override
        public boolean hasNext() {
            return this.curr == 0;
        }

        @Override
        public boolean hasPrevious() {
            return this.curr == 1;
        }

        @Override
        public double nextDouble() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = 1;
            return this.element;
        }

        @Override
        public double previousDouble() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = 0;
            return this.element;
        }

        @Override
        public int nextIndex() {
            return this.curr;
        }

        @Override
        public int previousIndex() {
            return this.curr - 1;
        }
    }

    public static class EmptyIterator
    extends AbstractDoubleListIterator
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public boolean hasPrevious() {
            return false;
        }

        @Override
        public double nextDouble() {
            throw new NoSuchElementException();
        }

        @Override
        public double previousDouble() {
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return 0;
        }

        @Override
        public int previousIndex() {
            return -1;
        }

        @Override
        public int skip(int n2) {
            return 0;
        }

        @Override
        public int back(int n2) {
            return 0;
        }

        public Object clone() {
            return EMPTY_ITERATOR;
        }

        private Object readResolve() {
            return EMPTY_ITERATOR;
        }
    }
}

