/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.it.unimi.dsi.fastutil.floats;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.Arrays;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.floats.AbstractFloatList;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.floats.AbstractFloatListIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.floats.FloatArrays;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.floats.FloatCollection;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.floats.FloatIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.floats.FloatIterators;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.floats.FloatList;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.floats.FloatListIterator;

public class FloatArrayList
extends AbstractFloatList
implements RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -7046029254386353130L;
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    protected transient float[] a;
    protected int size;
    private static final boolean ASSERTS = false;

    protected FloatArrayList(float[] a2, boolean dummy) {
        this.a = a2;
    }

    public FloatArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Initial capacity (" + capacity + ") is negative");
        }
        this.a = new float[capacity];
    }

    public FloatArrayList() {
        this(16);
    }

    public FloatArrayList(Collection<? extends Float> c2) {
        this(c2.size());
        this.size = FloatIterators.unwrap(FloatIterators.asFloatIterator(c2.iterator()), this.a);
    }

    public FloatArrayList(FloatCollection c2) {
        this(c2.size());
        this.size = FloatIterators.unwrap(c2.iterator(), this.a);
    }

    public FloatArrayList(FloatList l2) {
        this(l2.size());
        this.size = l2.size();
        l2.getElements(0, this.a, 0, this.size);
    }

    public FloatArrayList(float[] a2) {
        this(a2, 0, a2.length);
    }

    public FloatArrayList(float[] a2, int offset, int length) {
        this(length);
        System.arraycopy(a2, offset, this.a, 0, length);
        this.size = length;
    }

    public FloatArrayList(Iterator<? extends Float> i2) {
        this();
        while (i2.hasNext()) {
            this.add(i2.next());
        }
    }

    public FloatArrayList(FloatIterator i2) {
        this();
        while (i2.hasNext()) {
            this.add(i2.nextFloat());
        }
    }

    public float[] elements() {
        return this.a;
    }

    public static FloatArrayList wrap(float[] a2, int length) {
        if (length > a2.length) {
            throw new IllegalArgumentException("The specified length (" + length + ") is greater than the array size (" + a2.length + ")");
        }
        FloatArrayList l2 = new FloatArrayList(a2, false);
        l2.size = length;
        return l2;
    }

    public static FloatArrayList wrap(float[] a2) {
        return FloatArrayList.wrap(a2, a2.length);
    }

    public void ensureCapacity(int capacity) {
        this.a = FloatArrays.ensureCapacity(this.a, capacity, this.size);
    }

    private void grow(int capacity) {
        this.a = FloatArrays.grow(this.a, capacity, this.size);
    }

    @Override
    public void add(int index, float k2) {
        this.ensureIndex(index);
        this.grow(this.size + 1);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + 1, this.size - index);
        }
        this.a[index] = k2;
        ++this.size;
    }

    @Override
    public boolean add(float k2) {
        this.grow(this.size + 1);
        this.a[this.size++] = k2;
        return true;
    }

    @Override
    public float getFloat(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return this.a[index];
    }

    @Override
    public int indexOf(float k2) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (k2 != this.a[i2]) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(float k2) {
        int i2 = this.size;
        while (i2-- != 0) {
            if (k2 != this.a[i2]) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public float removeFloat(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        float old = this.a[index];
        --this.size;
        if (index != this.size) {
            System.arraycopy(this.a, index + 1, this.a, index, this.size - index);
        }
        return old;
    }

    @Override
    public boolean rem(float k2) {
        int index = this.indexOf(k2);
        if (index == -1) {
            return false;
        }
        this.removeFloat(index);
        return true;
    }

    @Override
    public float set(int index, float k2) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        float old = this.a[index];
        this.a[index] = k2;
        return old;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void size(int size) {
        if (size > this.a.length) {
            this.ensureCapacity(size);
        }
        if (size > this.size) {
            FloatArrays.fill(this.a, this.size, size, 0.0f);
        }
        this.size = size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public void trim() {
        this.trim(0);
    }

    public void trim(int n2) {
        if (n2 >= this.a.length || this.size == this.a.length) {
            return;
        }
        float[] t2 = new float[Math.max(n2, this.size)];
        System.arraycopy(this.a, 0, t2, 0, this.size);
        this.a = t2;
    }

    @Override
    public void getElements(int from, float[] a2, int offset, int length) {
        FloatArrays.ensureOffsetLength(a2, offset, length);
        System.arraycopy(this.a, from, a2, offset, length);
    }

    @Override
    public void removeElements(int from, int to) {
        Arrays.ensureFromTo(this.size, from, to);
        System.arraycopy(this.a, to, this.a, from, this.size - to);
        this.size -= to - from;
    }

    @Override
    public void addElements(int index, float[] a2, int offset, int length) {
        this.ensureIndex(index);
        FloatArrays.ensureOffsetLength(a2, offset, length);
        this.grow(this.size + length);
        System.arraycopy(this.a, index, this.a, index + length, this.size - index);
        System.arraycopy(a2, offset, this.a, index, length);
        this.size += length;
    }

    @Override
    public float[] toFloatArray(float[] a2) {
        if (a2 == null || a2.length < this.size) {
            a2 = new float[this.size];
        }
        System.arraycopy(this.a, 0, a2, 0, this.size);
        return a2;
    }

    @Override
    public boolean addAll(int index, FloatCollection c2) {
        this.ensureIndex(index);
        int n2 = c2.size();
        if (n2 == 0) {
            return false;
        }
        this.grow(this.size + n2);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + n2, this.size - index);
        }
        FloatIterator i2 = c2.iterator();
        this.size += n2;
        while (n2-- != 0) {
            this.a[index++] = i2.nextFloat();
        }
        return true;
    }

    @Override
    public boolean addAll(int index, FloatList l2) {
        this.ensureIndex(index);
        int n2 = l2.size();
        if (n2 == 0) {
            return false;
        }
        this.grow(this.size + n2);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + n2, this.size - index);
        }
        l2.getElements(0, this.a, index, n2);
        this.size += n2;
        return true;
    }

    @Override
    public FloatListIterator listIterator(final int index) {
        this.ensureIndex(index);
        return new AbstractFloatListIterator(){
            int pos;
            int last;
            {
                this.pos = index;
                this.last = -1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < FloatArrayList.this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > 0;
            }

            @Override
            public float nextFloat() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos++;
                return FloatArrayList.this.a[this.last];
            }

            @Override
            public float previousFloat() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.last = --this.pos;
                return FloatArrayList.this.a[this.pos];
            }

            @Override
            public int nextIndex() {
                return this.pos;
            }

            @Override
            public int previousIndex() {
                return this.pos - 1;
            }

            @Override
            public void add(float k2) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                FloatArrayList.this.add(this.pos++, k2);
                this.last = -1;
            }

            @Override
            public void set(float k2) {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                FloatArrayList.this.set(this.last, k2);
            }

            @Override
            public void remove() {
                if (this.last == -1) {
                    throw new IllegalStateException();
                }
                FloatArrayList.this.removeFloat(this.last);
                if (this.last < this.pos) {
                    --this.pos;
                }
                this.last = -1;
            }
        };
    }

    public FloatArrayList clone() {
        FloatArrayList c2 = new FloatArrayList(this.size);
        System.arraycopy(this.a, 0, c2.a, 0, this.size);
        c2.size = this.size;
        return c2;
    }

    public boolean equals(FloatArrayList l2) {
        if (l2 == this) {
            return true;
        }
        int s2 = this.size();
        if (s2 != l2.size()) {
            return false;
        }
        float[] a1 = this.a;
        float[] a2 = l2.a;
        while (s2-- != 0) {
            if (a1[s2] == a2[s2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(FloatArrayList l2) {
        int i2;
        int s1 = this.size();
        int s2 = l2.size();
        float[] a1 = this.a;
        float[] a2 = l2.a;
        for (i2 = 0; i2 < s1 && i2 < s2; ++i2) {
            float e1 = a1[i2];
            float e2 = a2[i2];
            int r2 = Float.compare(e1, e2);
            if (r2 == 0) continue;
            return r2;
        }
        return i2 < s2 ? -1 : (i2 < s1 ? 1 : 0);
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        for (int i2 = 0; i2 < this.size; ++i2) {
            s2.writeFloat(this.a[i2]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.a = new float[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.a[i2] = s2.readFloat();
        }
    }
}

