/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.parquet.it.unimi.dsi.fastutil.ints;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.ints.IntCollection;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.ints.IntIterator;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.ints.IntIterators;
import shaded.org.apache.parquet.it.unimi.dsi.fastutil.objects.ObjectIterators;

public abstract class AbstractIntCollection
extends AbstractCollection<Integer>
implements IntCollection {
    protected AbstractIntCollection() {
    }

    @Override
    public int[] toArray(int[] a2) {
        return this.toIntArray(a2);
    }

    @Override
    public int[] toIntArray() {
        return this.toIntArray(null);
    }

    @Override
    public int[] toIntArray(int[] a2) {
        if (a2 == null || a2.length < this.size()) {
            a2 = new int[this.size()];
        }
        IntIterators.unwrap(this.iterator(), a2);
        return a2;
    }

    @Override
    public boolean addAll(IntCollection c2) {
        boolean retVal = false;
        IntIterator i2 = c2.iterator();
        int n2 = c2.size();
        while (n2-- != 0) {
            if (!this.add(i2.nextInt())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean containsAll(IntCollection c2) {
        IntIterator i2 = c2.iterator();
        int n2 = c2.size();
        while (n2-- != 0) {
            if (this.contains(i2.nextInt())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainAll(IntCollection c2) {
        boolean retVal = false;
        int n2 = this.size();
        IntIterator i2 = this.iterator();
        while (n2-- != 0) {
            if (c2.contains(i2.nextInt())) continue;
            i2.remove();
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean removeAll(IntCollection c2) {
        boolean retVal = false;
        int n2 = c2.size();
        IntIterator i2 = c2.iterator();
        while (n2-- != 0) {
            if (!this.rem(i2.nextInt())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public Object[] toArray() {
        Object[] a2 = new Object[this.size()];
        ObjectIterators.unwrap(this.iterator(), a2);
        return a2;
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        if (a2.length < this.size()) {
            a2 = (Object[])Array.newInstance(a2.getClass().getComponentType(), this.size());
        }
        ObjectIterators.unwrap(this.iterator(), a2);
        return a2;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c2) {
        boolean retVal = false;
        Iterator<? extends Integer> i2 = c2.iterator();
        int n2 = c2.size();
        while (n2-- != 0) {
            if (!this.add(i2.next())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean add(int k2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public IntIterator intIterator() {
        return this.iterator();
    }

    @Override
    public abstract IntIterator iterator();

    @Override
    public boolean remove(Object ok) {
        return this.rem((Integer)ok);
    }

    @Override
    public boolean add(Integer o2) {
        return this.add((int)o2);
    }

    public boolean rem(Object o2) {
        return this.rem((Integer)o2);
    }

    @Override
    public boolean contains(Object o2) {
        return this.contains((Integer)o2);
    }

    @Override
    public boolean contains(int k2) {
        IntIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (k2 != iterator.nextInt()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean rem(int k2) {
        IntIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (k2 != iterator.nextInt()) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c2) {
        int n2 = c2.size();
        Iterator<?> i2 = c2.iterator();
        while (n2-- != 0) {
            if (this.contains(i2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        boolean retVal = false;
        int n2 = this.size();
        IntIterator i2 = this.iterator();
        while (n2-- != 0) {
            if (c2.contains(i2.next())) continue;
            i2.remove();
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        boolean retVal = false;
        int n2 = c2.size();
        Iterator<?> i2 = c2.iterator();
        while (n2-- != 0) {
            if (!this.remove(i2.next())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder();
        IntIterator i2 = this.iterator();
        int n2 = this.size();
        boolean first = true;
        s2.append("{");
        while (n2-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            int k2 = i2.nextInt();
            s2.append(String.valueOf(k2));
        }
        s2.append("}");
        return s2.toString();
    }
}

