/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.beanutils;

import java.util.Map;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanUtils {
    private static void handleReflectionException(Exception e) {
        ReflectionUtils.handleReflectionException((Exception)e);
    }

    public static Object cloneBean(Object bean) {
        try {
            return org.apache.commons.beanutils.BeanUtils.cloneBean((Object)bean);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
            return null;
        }
    }

    public static <T> T copyProperties(Class<T> destClass, Object orig) {
        try {
            T target = destClass.newInstance();
            BeanUtils.copyProperties(target, orig);
            return target;
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
            return null;
        }
    }

    public static void copyProperties(Object dest, Object orig) {
        try {
            org.apache.commons.beanutils.BeanUtils.copyProperties((Object)dest, (Object)orig);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
        }
    }

    public static void copyProperty(Object bean, String name, Object value) {
        try {
            org.apache.commons.beanutils.BeanUtils.copyProperty((Object)bean, (String)name, (Object)value);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
        }
    }

    public static Map describe(Object bean) {
        try {
            return org.apache.commons.beanutils.BeanUtils.describe((Object)bean);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
            return null;
        }
    }

    public static String[] getArrayProperty(Object bean, String name) {
        try {
            return org.apache.commons.beanutils.BeanUtils.getArrayProperty((Object)bean, (String)name);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
            return null;
        }
    }

    public static String getIndexedProperty(Object bean, String name, int index) {
        try {
            return org.apache.commons.beanutils.BeanUtils.getIndexedProperty((Object)bean, (String)name, (int)index);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
            return null;
        }
    }

    public static String getIndexedProperty(Object bean, String name) {
        try {
            return org.apache.commons.beanutils.BeanUtils.getIndexedProperty((Object)bean, (String)name);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
            return null;
        }
    }

    public static String getMappedProperty(Object bean, String name, String key) {
        try {
            return org.apache.commons.beanutils.BeanUtils.getMappedProperty((Object)bean, (String)name, (String)key);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
            return null;
        }
    }

    public static String getMappedProperty(Object bean, String name) {
        try {
            return org.apache.commons.beanutils.BeanUtils.getMappedProperty((Object)bean, (String)name);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
            return null;
        }
    }

    public static String getNestedProperty(Object bean, String name) {
        try {
            return org.apache.commons.beanutils.BeanUtils.getNestedProperty((Object)bean, (String)name);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
            return null;
        }
    }

    public static String getProperty(Object bean, String name) {
        try {
            return org.apache.commons.beanutils.BeanUtils.getProperty((Object)bean, (String)name);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
            return null;
        }
    }

    public static String getSimpleProperty(Object bean, String name) {
        try {
            return org.apache.commons.beanutils.BeanUtils.getSimpleProperty((Object)bean, (String)name);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
            return null;
        }
    }

    public static void populate(Object bean, Map properties) {
        try {
            org.apache.commons.beanutils.BeanUtils.populate((Object)bean, (Map)properties);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
        }
    }

    public static void setProperty(Object bean, String name, Object value) {
        try {
            org.apache.commons.beanutils.BeanUtils.setProperty((Object)bean, (String)name, (Object)value);
        }
        catch (Exception e) {
            BeanUtils.handleReflectionException(e);
        }
    }
}

