/*
 * Decompiled with CFR 0.152.
 */
package cn.org.rapid_framework.cache.aop.interceptor;

import cn.org.rapid_framework.cache.Cache;
import cn.org.rapid_framework.cache.aop.annotation.MethodCache;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class AnnotationMethodCacheInterceptor
implements MethodInterceptor,
BeanFactoryAware,
InitializingBean {
    private Cache methodCache;
    private BeanFactory beanFactory;
    private String methodCacheBeanName = null;
    private String cacheKeyPrefix = "";

    public void setMethodCache(Cache methodCache) {
        this.methodCache = methodCache;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (invocation.getMethod().isAnnotationPresent(MethodCache.class)) {
            String targetName = invocation.getThis().getClass().getName();
            String methodName = invocation.getMethod().getName();
            Object[] arguments = invocation.getArguments();
            MethodCache annotation = invocation.getMethod().getAnnotation(MethodCache.class);
            String cacheKey = this.getCackeKey(targetName, methodName, arguments, annotation);
            int expireSeconds = (int)annotation.expireTime();
            return this.getResult(cacheKey, invocation, expireSeconds);
        }
        return invocation.proceed();
    }

    private Object getResult(String cacheKey, MethodInvocation invocation, int expireSeconds) throws Throwable {
        Object result = this.methodCache.get(cacheKey);
        if (result == null) {
            result = invocation.proceed();
            this.methodCache.set(cacheKey, result, expireSeconds);
        }
        return result;
    }

    protected String getCackeKey(String className, String methodName, Object[] arguments, MethodCache annotation) {
        String cacheKey = null;
        cacheKey = StringUtils.isEmpty((String)annotation.cacheKey()) ? this.createDefaultCacheKey(className, methodName, arguments) : this.createCacheKey(annotation.cacheKey(), arguments);
        return this.cacheKeyPrefix + cacheKey;
    }

    protected String createCacheKey(String cacheKey, Object[] args) {
        String result = cacheKey;
        if (cacheKey.indexOf("{args}") >= 0) {
            result = StringUtils.replace((String)result, (String)"{args}", (String)("" + StringUtils.join((Object[])args, (char)',')));
        }
        return String.format(result, args);
    }

    protected String createDefaultCacheKey(String className, String methodName, Object[] arguments) {
        StringBuilder datakey = new StringBuilder();
        datakey.append(className).append(".").append(methodName).append("(");
        if (arguments != null) {
            for (int i = 0; i < arguments.length; ++i) {
                Object arg = arguments[i];
                datakey.append(this.objectToString(arg));
                if (i == arguments.length - 1) continue;
                datakey.append(",");
            }
        }
        datakey.append(")");
        return datakey.toString();
    }

    private String objectToString(Object arg) {
        String argString = null;
        argString = arg == null ? "" : (arg.getClass().isArray() ? "[" + StringUtils.join((Object[])((Object[])arg), (char)',') + "]" : (arg instanceof Iterable ? "[" + StringUtils.join(((Iterable)arg).iterator(), (char)',') + "]" : arg.toString()));
        return argString;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setMethodCacheBeanName(String methodCacheBeanName) {
        this.methodCacheBeanName = methodCacheBeanName;
    }

    public String getCacheKeyPrefix() {
        return this.cacheKeyPrefix;
    }

    public void setCacheKeyPrefix(String cacheKeyPrefix) {
        this.cacheKeyPrefix = cacheKeyPrefix == null ? "" : cacheKeyPrefix;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.methodCache == null) {
            this.methodCache = (Cache)this.beanFactory.getBean(this.methodCacheBeanName);
        }
        Assert.notNull((Object)this.methodCache, (String)"'methodCache' must be not null");
    }
}

